/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageChangeSettings2 {
    private static final int MAX_TYPE_LENGTH = 100;
    UUID traderID;
    ResourceLocation type;
    CompoundTag updateInfo;

    public MessageChangeSettings2(UUID traderID, ResourceLocation type, CompoundTag updateInfo) {
        this.traderID = traderID;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    public static void encode(MessageChangeSettings2 message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.traderID);
        buffer.m_130072_(message.type.toString(), 100);
        buffer.m_130079_(message.updateInfo);
    }

    public static MessageChangeSettings2 decode(FriendlyByteBuf buffer) {
        return new MessageChangeSettings2(buffer.m_130259_(), new ResourceLocation(buffer.m_130136_(100)), buffer.m_130261_());
    }

    public static void handle(MessageChangeSettings2 message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData data;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (data = TradingOffice.getData(message.traderID)) != null) {
                data.changeSettings(message.type, (Player)player, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

