/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateTradeRule2 {
    private UUID traderID;
    private int index;
    private ResourceLocation type;
    private CompoundTag updateInfo;

    public MessageUpdateTradeRule2(UUID traderID, ResourceLocation type, CompoundTag updateInfo) {
        this(traderID, -1, type, updateInfo);
    }

    public MessageUpdateTradeRule2(UUID traderID, int index, ResourceLocation type, CompoundTag updateInfo) {
        this.traderID = traderID;
        this.index = index;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    public static void encode(MessageUpdateTradeRule2 message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.traderID);
        buffer.writeInt(message.index);
        buffer.m_130070_(message.type.toString());
        buffer.m_130079_(message.updateInfo);
    }

    public static MessageUpdateTradeRule2 decode(FriendlyByteBuf buffer) {
        return new MessageUpdateTradeRule2(buffer.m_130259_(), buffer.readInt(), new ResourceLocation(buffer.m_130277_()), buffer.m_130261_());
    }

    public static void handle(MessageUpdateTradeRule2 message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData trader;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (trader = TradingOffice.getData(message.traderID)) instanceof ITradeRuleHandler.ITradeRuleMessageHandler) {
                ((ITradeRuleHandler.ITradeRuleMessageHandler)((Object)trader)).receiveTradeRuleMessage((Player)player, message.index, message.type, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

