/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.common;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TraderItemStorage
implements IItemHandler,
ICanCopy<TraderItemStorage> {
    private final ITraderItemFilter filter;
    private List<ItemStack> storage = new ArrayList<ItemStack>();

    public TraderItemStorage(@Nonnull ITraderItemFilter filter) {
        this.filter = filter;
    }

    public CompoundTag save(CompoundTag compound, String tag) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.storage.size(); ++i) {
            ItemStack item = this.storage.get(i);
            if (item.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            item.m_41739_(itemTag);
            itemTag.m_128405_("Count", item.m_41613_());
            list.add((Object)itemTag);
        }
        compound.m_128365_(tag, (Tag)list);
        return compound;
    }

    public void load(CompoundTag compound, String tag) {
        if (compound.m_128425_(tag, 9)) {
            ListTag list = compound.m_128437_(tag, 10);
            this.storage.clear();
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag itemTag = list.m_128728_(i);
                ItemStack item = ItemStack.m_41712_((CompoundTag)itemTag);
                item.m_41764_(itemTag.m_128451_("Count"));
                if (item.m_41619_()) continue;
                this.storage.add(item);
            }
        }
    }

    public void loadFromContainer(Container container) {
        this.storage.clear();
        for (int i = 0; i < container.m_6643_(); ++i) {
            this.forceAddItem(container.m_8020_(i));
        }
    }

    public List<ItemStack> getContents() {
        return this.storage;
    }

    public int getSlotCount() {
        return this.storage.size();
    }

    public boolean hasItem(ItemStack item) {
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            return stack.m_41613_() >= item.m_41613_();
        }
        return false;
    }

    public boolean hasItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean allowItem(ItemStack item) {
        if (item.m_41619_()) {
            return false;
        }
        return this.filter.isItemRelevant(item);
    }

    public int getMaxAmount() {
        return this.filter.getStorageStackLimit();
    }

    public int getItemCount(ItemStack item) {
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            return stack.m_41613_();
        }
        return 0;
    }

    public int getItemTagCount(ResourceLocation itemTag, Item ... blacklistItems) {
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        int count = 0;
        for (ItemStack stack : this.storage) {
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.m_41720_())) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    public int getFittableAmount(ItemStack item) {
        if (!this.allowItem(item)) {
            return 0;
        }
        return this.getMaxAmount() - this.getItemCount(item);
    }

    public boolean canFitItem(ItemStack item) {
        return this.getFittableAmount(item) >= item.m_41613_();
    }

    public boolean canFitItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.canFitItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean addItem(ItemStack item) {
        if (!this.canFitItem(item)) {
            return false;
        }
        this.forceAddItem(item);
        return true;
    }

    public void tryAddItem(ItemStack item) {
        if (!this.allowItem(item)) {
            return;
        }
        int amountToAdd = Math.min(item.m_41613_(), this.getFittableAmount(item));
        if (amountToAdd > 0) {
            ItemStack addStack = item.m_41620_(amountToAdd);
            this.forceAddItem(addStack);
        }
    }

    public void forceAddItem(ItemStack item) {
        if (item.m_41619_()) {
            return;
        }
        for (int i = 0; i < this.storage.size(); ++i) {
            ItemStack stack = this.storage.get(i);
            if (!InventoryUtil.ItemMatches(stack, item)) continue;
            stack.m_41769_(item.m_41613_());
            return;
        }
        this.storage.add(item.m_41777_());
    }

    public ItemStack removeItem(ItemStack item) {
        if (!this.hasItem(item)) {
            return ItemStack.f_41583_;
        }
        for (int i = 0; i < this.storage.size(); ++i) {
            ItemStack stack = this.storage.get(i);
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            int amountToRemove = Math.min(item.m_41613_(), item.m_41741_());
            ItemStack output = stack.m_41620_(amountToRemove);
            if (stack.m_41619_()) {
                this.storage.remove(i);
            }
            return output;
        }
        return ItemStack.f_41583_;
    }

    public void removeItemTagCount(ResourceLocation itemTag, int count, List<ItemStack> ignoreIfPossible, Item ... blacklistItems) {
        int amountToTake;
        ItemStack stack;
        int i;
        ArrayList blacklist = Lists.newArrayList((Object[])blacklistItems);
        for (i = 0; i < this.storage.size() && count > 0; ++i) {
            stack = this.storage.get(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.m_41720_()) || TraderItemStorage.ListContains(ignoreIfPossible, stack)) continue;
            amountToTake = Math.min(count, stack.m_41613_());
            count -= amountToTake;
            stack.m_41774_(amountToTake);
            if (!stack.m_41619_()) continue;
            this.storage.remove(i);
            --i;
        }
        for (i = 0; i < this.storage.size() && count > 0; ++i) {
            stack = this.storage.get(i);
            if (!InventoryUtil.ItemHasTag(stack, itemTag) || blacklist.contains(stack.m_41720_())) continue;
            amountToTake = Math.min(count, stack.m_41613_());
            count -= amountToTake;
            stack.m_41774_(amountToTake);
            if (!stack.m_41619_()) continue;
            this.storage.remove(i);
            --i;
        }
    }

    private static boolean ListContains(List<ItemStack> list, ItemStack stack) {
        for (ItemStack item : list) {
            if (!InventoryUtil.ItemMatches(item, stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public TraderItemStorage copy() {
        CompoundTag tag = this.save(new CompoundTag(), "copy");
        TraderItemStorage copy = new TraderItemStorage(this.filter);
        copy.load(tag, "copy");
        return copy;
    }

    public int getSlots() {
        return this.storage.size() + 1;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot >= 0 && slot < this.storage.size()) {
            return this.storage.get(slot);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        int amountToAdd = Math.min(stack.m_41613_(), this.getFittableAmount(stack));
        ItemStack remainder = stack.m_41777_();
        if (amountToAdd >= stack.m_41613_()) {
            remainder = ItemStack.f_41583_;
        } else {
            remainder.m_41774_(amountToAdd);
        }
        if (!simulate && amountToAdd > 0) {
            ItemStack addedStack = stack.m_41777_();
            addedStack.m_41764_(amountToAdd);
            this.forceAddItem(addedStack);
        }
        return remainder;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        ItemStack stackInSlot = this.getStackInSlot(slot);
        int amountToRemove = Math.min(amount, stackInSlot.m_41613_());
        ItemStack removedStack = stackInSlot.m_41777_();
        if (amountToRemove > 0) {
            removedStack.m_41764_(amountToRemove);
        } else {
            removedStack = ItemStack.f_41583_;
        }
        if (!simulate && amountToRemove > 0) {
            this.removeItem(removedStack);
        }
        return removedStack;
    }

    public int getSlotLimit(int slot) {
        return this.getMaxAmount();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return this.allowItem(stack);
    }

    public static interface ITraderItemFilter {
        public boolean isItemRelevant(ItemStack var1);

        public int getStorageStackLimit();
    }

    public static class LockedTraderStorage
    extends TraderItemStorage {
        public LockedTraderStorage(ITraderItemFilter filter) {
            super(filter);
        }

        @Override
        public boolean allowItem(ItemStack item) {
            return false;
        }
    }
}

