/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.interfacing.handlers;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.trader.interfacing.handlers.SidedHandler;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.settings.directional.DirectionalSettings;
import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ConfigurableSidedHandler<H>
extends SidedHandler<H> {
    protected final DirectionalSettings inputSides;
    protected final DirectionalSettings outputSides;
    protected static final String UPDATE_INPUT_SIDE = "inputSide";
    protected static final String UPDATE_OUTPUT_SIDE = "outputSide";

    public DirectionalSettings getInputSides() {
        return this.inputSides;
    }

    public DirectionalSettings getOutputSides() {
        return this.outputSides;
    }

    protected ConfigurableSidedHandler() {
        this((ImmutableList<Direction>)ImmutableList.of());
    }

    protected ConfigurableSidedHandler(ImmutableList<Direction> ignoreSides) {
        this.inputSides = new DirectionalSettings(ignoreSides);
        this.outputSides = new DirectionalSettings(ignoreSides);
    }

    public void toggleInputSide(@Nonnull Direction side) {
        this.inputSides.set(side, !this.inputSides.get(side));
        this.markDirty();
        if (this.isClient()) {
            CompoundTag message = Settings.initUpdateInfo(UPDATE_INPUT_SIDE);
            message.m_128405_("side", side.m_122411_());
            message.m_128379_("newValue", this.inputSides.get(side));
            this.sendMessage(message);
        }
    }

    public void toggleOutputSide(Direction side) {
        this.outputSides.set(side, !this.outputSides.get(side));
        this.markDirty();
        if (this.isClient()) {
            CompoundTag message = Settings.initUpdateInfo(UPDATE_OUTPUT_SIDE);
            message.m_128405_("side", side.m_122411_());
            message.m_128379_("newValue", this.outputSides.get(side));
            this.sendMessage(message);
        }
    }

    @Override
    public void receiveMessage(CompoundTag compound) {
        if (Settings.checkUpdateType(compound, UPDATE_INPUT_SIDE)) {
            Direction side = Direction.m_122376_((int)compound.m_128451_("side"));
            if (compound.m_128471_("newValue") != this.inputSides.get(side)) {
                this.toggleInputSide(side);
            }
        } else if (Settings.checkUpdateType(compound, UPDATE_OUTPUT_SIDE)) {
            Direction side = Direction.m_122376_((int)compound.m_128451_("side"));
            if (compound.m_128471_("newValue") != this.outputSides.get(side)) {
                this.toggleOutputSide(side);
            }
        }
    }

    @Override
    public final CompoundTag save() {
        CompoundTag compound = new CompoundTag();
        compound.m_128365_("InputSides", (Tag)this.inputSides.save(new CompoundTag()));
        compound.m_128365_("OutputSides", (Tag)this.outputSides.save(new CompoundTag()));
        this.saveAdditional(compound);
        return compound;
    }

    protected void saveAdditional(CompoundTag compound) {
    }

    @Override
    public void load(CompoundTag compound) {
        if (compound.m_128425_("InputSides", 10)) {
            this.inputSides.load(compound.m_128469_("InputSides"));
        }
        if (compound.m_128425_("OutputSides", 10)) {
            this.outputSides.load(compound.m_128469_("OutputSides"));
        }
    }
}

