/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.settings;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class Settings {
    private final IMarkDirty dirtyMarker;
    private final BiConsumer<ResourceLocation, CompoundTag> sendToServer;
    private final ResourceLocation type;
    protected final ITrader trader;

    public final ResourceLocation getType() {
        return this.type;
    }

    protected Settings(ITrader trader, IMarkDirty dirtyMarker, BiConsumer<ResourceLocation, CompoundTag> sendToServer, ResourceLocation type) {
        this.dirtyMarker = dirtyMarker;
        this.sendToServer = sendToServer;
        this.type = type;
        this.trader = trader;
    }

    public final void markDirty() {
        this.dirtyMarker.markDirty();
    }

    public final void sendToServer(CompoundTag updateInfo) {
        if (updateInfo != null) {
            this.sendToServer.accept(this.type, updateInfo);
        }
    }

    public abstract CompoundTag save(CompoundTag var1);

    public abstract void load(CompoundTag var1);

    public abstract void changeSetting(Player var1, CompoundTag var2);

    public static final CompoundTag initUpdateInfo(String updateType) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("UpdateType", updateType);
        return compound;
    }

    protected final boolean isUpdateType(CompoundTag updateInfo, String updateType) {
        return Settings.checkUpdateType(updateInfo, updateType);
    }

    public static final boolean checkUpdateType(CompoundTag updateInfo, String updateType) {
        if (updateInfo.m_128425_("UpdateType", 8)) {
            return updateInfo.m_128461_("UpdateType").contentEquals(updateType);
        }
        return false;
    }

    public static final void PermissionWarning(Player player, String action, String permission) {
        Settings.PermissionWarning(player, action, permission, 0, 1);
    }

    public static final void PermissionWarning(Player player, String action, String permission, int hasLevel, int requiredLevel) {
        LightmansCurrency.LogWarning(player.m_7755_().getString() + " attempted to " + action + " without the appropriate permission level.\nHas " + permission + " level " + hasLevel + ". Level " + requiredLevel + " required.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<SettingsTab> getSettingsTabs();

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<SettingsTab> getBackEndSettingsTabs();

    @OnlyIn(value=Dist.CLIENT)
    public abstract List<PermissionOption> getPermissionOptions();

    public static interface IMarkDirty {
        public void markDirty();
    }
}

