/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ItemEditWidget
extends AbstractWidget
implements ScrollBarWidget.IScrollable {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/item_edit.png");
    public static List<CreativeModeTab> ITEM_GROUP_BLACKLIST = ImmutableList.of((Object)CreativeModeTab.f_40760_, (Object)CreativeModeTab.f_40761_, (Object)CreativeModeTab.f_40754_);
    private int scroll = 0;
    private int stackCount = 1;
    private int columns;
    private int rows;
    public int searchOffX;
    public int searchOffY;
    public int stackSizeOffX;
    public int stackSizeOffY;
    private static List<ItemStack> allItems;
    private List<ItemStack> searchResultItems;
    private String searchString;
    EditBox searchInput;
    ScrollListener stackScrollListener;
    private final IItemEditListener listener;
    private final Font font;

    public ItemEditWidget(int x, int y, int columns, int rows, IItemEditListener listener) {
        super(x, y, columns * 18, rows * 18, (Component)new TextComponent(""));
        this.listener = listener;
        this.columns = columns;
        this.rows = rows;
        this.searchOffX = this.f_93618_ - 90;
        this.searchOffY = -13;
        this.stackSizeOffX = this.f_93618_ + 13;
        this.stackSizeOffY = 0;
        Minecraft mc = Minecraft.m_91087_();
        this.font = mc.f_91062_;
        this.initItemList();
        this.modifySearch("");
    }

    private void initItemList() {
        if (allItems != null) {
            return;
        }
        allItems = new ArrayList<ItemStack>();
        for (CreativeModeTab group : CreativeModeTab.f_40748_) {
            if (ITEM_GROUP_BLACKLIST.contains(group)) continue;
            NonNullList items = NonNullList.m_122779_();
            group.m_6151_(items);
            for (ItemStack stack : items) {
                if (!ItemEditWidget.itemListAlreadyContains(stack)) {
                    allItems.add(stack);
                }
                if (stack.m_41720_() != Items.f_42690_) continue;
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    for (int newLevel = level - 1; newLevel > 0; --newLevel) {
                        ItemStack newBook = new ItemStack((ItemLike)Items.f_42690_);
                        EnchantmentHelper.m_44865_((Map)ImmutableMap.of((Object)enchantment, (Object)newLevel), (ItemStack)newBook);
                        if (ItemEditWidget.itemListAlreadyContains(newBook)) continue;
                        allItems.add(newBook);
                    }
                });
            }
        }
    }

    private static boolean itemListAlreadyContains(ItemStack stack) {
        for (ItemStack s : allItems) {
            if (!InventoryUtil.ItemMatches(s, stack)) continue;
            return true;
        }
        return false;
    }

    private List<ItemStack> getFilteredItems() {
        ArrayList results = Lists.newArrayList();
        ItemTradeData trade = this.listener.getTrade();
        ItemTradeRestriction restriction = trade == null ? ItemTradeRestriction.NONE : this.listener.getTrade().getRestriction();
        for (int i = 0; i < allItems.size(); ++i) {
            if (!restriction.allowItemSelectItem(allItems.get(i))) continue;
            results.add(allItems.get(i));
        }
        return results;
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.searchResultItems.size() - 1) / this.columns - this.rows + 1, 0);
    }

    public void refreshPage() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
        int startIndex = this.scroll * this.columns;
        for (int i = 0; i < this.rows * this.columns; ++i) {
            int thisIndex = startIndex + i;
            if (thisIndex >= this.searchResultItems.size()) continue;
            ItemStack stack = this.searchResultItems.get(thisIndex).m_41777_();
            stack.m_41764_(MathUtil.clamp(this.stackCount, 1, stack.m_41741_()));
        }
    }

    public void refreshSearch() {
        this.modifySearch(this.searchString);
    }

    public void modifySearch(String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (this.searchString.length() > 0) {
            this.searchResultItems = new ArrayList<ItemStack>();
            List<ItemStack> validItems = this.listener.restrictItemEditItems() ? this.getFilteredItems() : allItems;
            for (ItemStack stack : validItems) {
                if (stack.m_41786_().getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                if (stack.m_41720_().getRegistryName().toString().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                AtomicReference<Boolean> enchantmentMatch = new AtomicReference<Boolean>(false);
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                enchantments.forEach((enchantment, level) -> {
                    if (enchantment.getRegistryName().toString().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    } else if (enchantment.m_44700_(level.intValue()).getString().toLowerCase().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    }
                });
                if (!enchantmentMatch.get().booleanValue()) continue;
                this.searchResultItems.add(stack);
            }
        } else {
            this.searchResultItems = this.listener.restrictItemEditItems() ? this.getFilteredItems() : allItems;
        }
        this.refreshPage();
    }

    public void init(Function<EditBox, EditBox> addWidget, Function<ScrollListener, ScrollListener> addListener) {
        this.searchInput = addWidget.apply(new EditBox(this.font, this.f_93620_ + this.searchOffX + 2, this.f_93621_ + this.searchOffY + 2, 79, 9, (Component)new TranslatableComponent("gui.lightmanscurrency.item_edit.search")));
        this.searchInput.m_94182_(false);
        this.searchInput.m_94199_(32);
        this.searchInput.m_94202_(0xFFFFFF);
        this.stackScrollListener = addListener.apply(new ScrollListener(this.f_93620_ + this.stackSizeOffX, this.f_93621_ + this.stackSizeOffY, 18, 18, this::stackCountScroll));
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.searchInput.f_93624_ = this.f_93624_;
        this.stackScrollListener.active = this.f_93624_;
        if (!this.f_93624_) {
            return;
        }
        if (!this.searchInput.m_94155_().toLowerCase().contentEquals(this.searchString)) {
            this.modifySearch(this.searchInput.m_94155_());
        }
        int index = this.scroll * this.columns;
        for (int y = 0; y < this.rows && index < this.searchResultItems.size(); ++y) {
            int yPos = this.f_93621_ + y * 18;
            for (int x = 0; x < this.columns && index < this.searchResultItems.size(); ++index, ++x) {
                int xPos = this.f_93620_ + x * 18;
                RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.m_93228_(pose, xPos, yPos, 0, 0, 18, 18);
                ItemRenderUtil.drawItemStack((GuiComponent)this, this.font, this.getQuantityFixedStack(this.searchResultItems.get(index)), xPos + 1, yPos + 1);
            }
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_93620_ + this.searchOffX, this.f_93621_ + this.searchOffY, 18, 0, 90, 12);
        this.m_93228_(pose, this.f_93620_ + this.stackSizeOffX, this.f_93621_ + this.stackSizeOffY, 108, 0, 18, 18);
    }

    public void tick() {
        this.searchInput.m_94120_();
    }

    private ItemStack getQuantityFixedStack(ItemStack stack) {
        ItemStack copy = stack.m_41777_();
        copy.m_41764_(Math.min(stack.m_41741_(), this.stackCount));
        return copy;
    }

    public void renderTooltips(Screen screen, PoseStack pose, int mouseX, int mouseY) {
        if (!this.f_93624_) {
            return;
        }
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            screen.m_96597_(pose, ItemRenderUtil.getTooltipFromItem(this.searchResultItems.get(hoveredSlot)), mouseX, mouseY);
        }
        if (this.isMouseOverStackSizeScroll(mouseX, mouseY)) {
            screen.m_96602_(pose, (Component)new TranslatableComponent("tooltip.lightmanscurrency.item_edit.scroll"), mouseX, mouseY);
        }
    }

    private boolean isMouseOverStackSizeScroll(int mouseX, int mouseY) {
        return mouseX >= this.f_93620_ + this.stackSizeOffX && mouseX < this.f_93620_ + this.stackSizeOffX + 18 && mouseY >= this.f_93621_ + this.stackSizeOffY && mouseY < this.f_93621_ + this.stackSizeOffY + 18;
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(this.f_93620_ + x * 18)) || !(mouseX < (double)(this.f_93620_ + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < this.rows && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(this.f_93621_ + y * 18)) || !(mouseY < (double)(this.f_93621_ + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            ItemStack stack = this.getQuantityFixedStack(this.searchResultItems.get(hoveredSlot));
            this.listener.onItemClicked(stack);
            return true;
        }
        return false;
    }

    public boolean stackCountScroll(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            if (this.stackCount < 64) {
                ++this.stackCount;
            }
        } else if (delta < 0.0 && this.stackCount > 1) {
            --this.stackCount;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll >= this.getMaxScroll()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.refreshPage();
    }

    public static interface IItemEditListener {
        public ItemTradeData getTrade();

        public boolean restrictItemEditItems();

        public void onItemClicked(ItemStack var1);
    }
}

