/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders.auction;

import com.google.common.base.Function;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.auction.AuctionStorageTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.auction.AuctionTradeCancelTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.auction.MessageStartBid;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AuctionHouseTrader
extends UniversalTraderData {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "auction_house");
    public static final IconData ICON = IconData.of(new ResourceLocation("lightmanscurrency", "textures/gui/icons.png"), 96, 16);
    List<AuctionTradeData> trades = new ArrayList<AuctionTradeData>();
    Map<UUID, AuctionPlayerStorage> storage = new HashMap<UUID, AuctionPlayerStorage>();
    private final List<Player> currentUsers = new ArrayList<Player>();

    public AuctionHouseTrader() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onRemoved() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @Override
    public Component getName() {
        return new TranslatableComponent("gui.lightmanscurrency.universaltrader.auction");
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    public AuctionTradeData getTrade(int tradeIndex) {
        try {
            return this.trades.get(tradeIndex);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean hasPersistentAuction(String id) {
        for (AuctionTradeData trade : this.trades) {
            if (!trade.isPersistentID(id) || !trade.isValid()) continue;
            return true;
        }
        return false;
    }

    public int getTradeIndex(AuctionTradeData trade) {
        return this.trades.indexOf(trade);
    }

    @Override
    public void markTradesDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::saveTrades));
    }

    public AuctionPlayerStorage getStorage(Player player) {
        return this.getStorage(PlayerReference.of(player));
    }

    public AuctionPlayerStorage getStorage(PlayerReference player) {
        if (player == null) {
            return null;
        }
        if (!this.storage.containsKey(player.id)) {
            this.storage.put(player.id, new AuctionPlayerStorage(player));
            this.markStorageDirty();
        }
        return this.storage.get(player.id);
    }

    public void markStorageDirty() {
        this.markDirty((Function<CompoundTag, CompoundTag>)((Function)this::saveStorage));
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            long currentTime = System.currentTimeMillis();
            boolean changed = false;
            boolean canDelete = !this.hasUser();
            for (int i = 0; i < this.trades.size(); ++i) {
                AuctionTradeData trade = this.trades.get(i);
                if (trade.hasExpired(currentTime)) {
                    trade.ExecuteTrade(this);
                    changed = true;
                }
                if (!canDelete || trade.isValid()) continue;
                this.trades.remove(i);
                --i;
            }
            if (changed) {
                this.markDirty(this.saveTrades(this.saveStorage(new CompoundTag())));
            }
        }
    }

    @Override
    public int getPermissionLevel(PlayerReference player, String permission) {
        if (permission == "openStorage") {
            return 1;
        }
        return 0;
    }

    @Override
    public int getPermissionLevel(Player player, String permission) {
        if (permission == "openStorage") {
            return 1;
        }
        return 0;
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        super.write(compound);
        this.saveTrades(compound);
        this.saveStorage(compound);
        return compound;
    }

    protected final CompoundTag saveTrades(CompoundTag compound) {
        ListTag list = new ListTag();
        for (int i = 0; i < this.trades.size(); ++i) {
            list.add((Object)this.trades.get(i).getAsNBT());
        }
        compound.m_128365_("Trades", (Tag)list);
        return compound;
    }

    protected final CompoundTag saveStorage(CompoundTag compound) {
        ListTag list = new ListTag();
        this.storage.forEach((player, storage) -> list.add((Object)storage.save(new CompoundTag())));
        compound.m_128365_("StorageData", (Tag)list);
        return compound;
    }

    @Override
    public void read(CompoundTag compound) {
        int i;
        if (compound.m_128441_("Trades")) {
            this.trades.clear();
            ListTag tradeList = compound.m_128437_("Trades", 10);
            for (i = 0; i < tradeList.size(); ++i) {
                this.trades.add(new AuctionTradeData(tradeList.m_128728_(i)));
            }
        }
        if (compound.m_128441_("StorageData")) {
            this.storage.clear();
            ListTag storageList = compound.m_128437_("StorageData", 10);
            for (i = 0; i < storageList.size(); ++i) {
                AuctionPlayerStorage storageEntry = new AuctionPlayerStorage(storageList.m_128728_(i));
                if (storageEntry.getOwner() == null) continue;
                this.storage.put(storageEntry.getOwner().id, storageEntry);
            }
        }
        super.read(compound);
    }

    @Override
    public int getTradeStock(int index) {
        return 0;
    }

    @Override
    public List<Settings> getAdditionalSettings() {
        return new ArrayList<Settings>();
    }

    @Override
    public void requestAddOrRemoveTrade(boolean isAdd) {
    }

    @Override
    public void addTrade(Player requestor) {
    }

    @Override
    public void removeTrade(Player requestor) {
    }

    public void addTrade(AuctionTradeData trade) {
        trade.startTimer();
        if (trade.isValid()) {
            this.trades.add(trade);
            this.markTradesDirty();
        } else {
            LightmansCurrency.LogError("Auction Trade is not fully valid. Unable to add it to the list.");
        }
    }

    @Override
    public ITradeRuleScreenHandler getRuleScreenHandler(int tradeIndex) {
        return null;
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        if (!context.hasPlayer()) {
            return TradeContext.TradeResult.FAIL_NOT_SUPPORTED;
        }
        LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(context.getPlayer()), (Object)new MessageStartBid(this.getTraderID(), tradeIndex));
        return TradeContext.TradeResult.SUCCESS;
    }

    public boolean makeBid(Player player, TraderMenu menu, int tradeIndex, CoinValue bidAmount) {
        AuctionTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            return false;
        }
        if (trade.hasExpired(System.currentTimeMillis())) {
            return false;
        }
        ItemStack wallet = LightmansCurrency.getWalletStack(player);
        long inventoryValue = MoneyUtil.getValue(menu.getCoinInventory());
        if (!wallet.m_41619_()) {
            inventoryValue += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (inventoryValue < bidAmount.getRawValue()) {
            return false;
        }
        if (trade.tryMakeBid(this, player, bidAmount)) {
            MoneyUtil.ProcessPayment(menu.getCoinInventory(), player, bidAmount);
            this.markDirty(this.saveTrades(this.saveStorage(new CompoundTag())));
            return true;
        }
        return false;
    }

    @Override
    public List<? extends TradeButton.ITradeData> getTradeInfo() {
        return this.trades;
    }

    @Override
    protected ItemLike getCategoryItem() {
        return ModItems.TRADING_CORE;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
    }

    @Override
    public ResourceLocation getTraderType() {
        return TYPE;
    }

    @Override
    public IconData getIcon() {
        return ICON;
    }

    @Override
    public CompoundTag getPersistentData() {
        return new CompoundTag();
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
    }

    @Override
    public java.util.function.Function<TradeButton.ITradeData, Boolean> getStorageDisplayFilter(TraderStorageMenu menu) {
        return trade -> {
            if (trade instanceof AuctionTradeData) {
                AuctionTradeData at = (AuctionTradeData)trade;
                return at.isOwner(menu.player) && at.isValid();
            }
            return false;
        };
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(1, new AuctionStorageTab(menu));
        menu.setTab(2, new AuctionTradeCancelTab(menu));
        menu.setTab(10, new AuctionCreateTab(menu));
    }

    @Override
    public boolean shouldRemove(MinecraftServer server) {
        return false;
    }

    @Override
    public boolean hasNoValidTrades() {
        return false;
    }

    public final boolean hasUser() {
        return this.currentUsers.size() > 0;
    }

    @Override
    public void userOpen(Player player) {
        this.currentUsers.add(player);
    }

    @Override
    public void userClose(Player player) {
        this.currentUsers.remove(player);
    }
}

