/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.enchantments;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.enchantments.SPacketMoneyMendingClink;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class MoneyMendingEnchantment
extends Enchantment {
    public MoneyMendingEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, EnchantmentCategory.BREAKABLE, slots);
    }

    public int m_6183_(int level) {
        return level * 25;
    }

    public int m_6175_(int level) {
        return this.m_6183_(level) + 50;
    }

    public boolean m_6591_() {
        return true;
    }

    public int m_6586_() {
        return 1;
    }

    protected boolean m_5975_(Enchantment otherEnchant) {
        return otherEnchant != Enchantments.f_44962_ && super.m_5975_(otherEnchant);
    }

    public static long getRepairCost() {
        return MoneyUtil.getValue(Config.getMoneyMendingCoinItem());
    }

    public static void runEntityTick(LivingEntity entity) {
        WalletCapability.getWalletHandler((Entity)entity).ifPresent(walletHandler -> {
            ItemStack wallet = walletHandler.getWallet();
            if (WalletItem.isWallet(wallet)) {
                NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(wallet);
                long currentWalletValue = MoneyUtil.getValue(walletInventory);
                long repairCost = MoneyMendingEnchantment.getRepairCost();
                if (repairCost > currentWalletValue) {
                    return;
                }
                Map.Entry entry = EnchantmentHelper.m_44839_((Enchantment)ModEnchantments.MONEY_MENDING, (LivingEntity)entity, ItemStack::m_41768_);
                if (entry != null) {
                    ItemStack item = (ItemStack)entry.getValue();
                    int currentDamage = item.m_41773_();
                    long repairAmount = Math.min((long)currentDamage, currentWalletValue / repairCost);
                    item.m_41721_(currentDamage - (int)repairAmount);
                    SimpleContainer newWalletInventory = new SimpleContainer(walletInventory.size());
                    for (ItemStack coinStack : MoneyUtil.getCoinsOfValue(currentWalletValue -= repairAmount * repairCost)) {
                        ItemStack leftovers = InventoryUtil.TryPutItemStack((Container)newWalletInventory, coinStack);
                        if (leftovers.m_41619_()) continue;
                        if (entity instanceof Player) {
                            ItemHandlerHelper.giveItemToPlayer((Player)((Player)entity), (ItemStack)leftovers);
                            continue;
                        }
                        IItemHandler entityInventory = (IItemHandler)entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).orElse(null);
                        if (entityInventory != null) {
                            leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)entityInventory, (ItemStack)leftovers, (boolean)false);
                        }
                        if (leftovers.m_41619_()) continue;
                        InventoryUtil.dumpContents(entity.f_19853_, entity.m_142538_(), leftovers);
                    }
                    WalletItem.putWalletInventory(wallet, InventoryUtil.buildList((Container)newWalletInventory));
                    walletHandler.setWallet(wallet);
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        if (player.f_36096_ instanceof WalletMenuBase) {
                            ((WalletMenuBase)player.f_36096_).reloadWalletContents();
                        }
                        LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new SPacketMoneyMendingClink());
                    }
                }
            }
        });
    }
}

