/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.items;

import io.github.lightman314.lightmanscurrency.core.ModItems;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class TicketItem
extends Item {
    public static final ResourceLocation TICKET_TAG = new ResourceLocation("lightmanscurrency", "ticket");
    public static final ResourceLocation TICKET_MATERIAL_TAG = new ResourceLocation("lightmanscurrency", "ticket_material");
    public static final TagKey<Item> TICKET_MATERIAL_KEY = TagKey.m_203882_((ResourceKey)ForgeRegistries.Keys.ITEMS, (ResourceLocation)TICKET_MATERIAL_TAG);

    public TicketItem(Item.Properties properties) {
        super(properties);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flagIn) {
        UUID ticketID;
        if (Screen.m_96638_() && (ticketID = TicketItem.GetTicketID(stack)) != null) {
            tooltip.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.ticket.id", new Object[]{ticketID}));
        }
    }

    public static boolean isMasterTicket(ItemStack ticket) {
        if (ticket.m_41619_() || !ticket.m_41782_()) {
            return false;
        }
        return ticket.m_41720_() == ModItems.TICKET_MASTER;
    }

    public static UUID GetTicketID(ItemStack ticket) {
        if (ticket.m_41619_() || !(ticket.m_41720_() instanceof TicketItem) || !ticket.m_41782_()) {
            return null;
        }
        CompoundTag ticketTag = ticket.m_41783_();
        if (!ticketTag.m_128441_("TicketID")) {
            return null;
        }
        return ticketTag.m_128342_("TicketID");
    }

    public static ItemStack CreateMasterTicket(UUID ticketID) {
        ItemStack ticket = new ItemStack((ItemLike)ModItems.TICKET_MASTER);
        if (ticketID != null) {
            ticket.m_41784_().m_128362_("TicketID", ticketID);
        }
        return ticket;
    }

    public static ItemStack CreateTicket(UUID ticketID) {
        return TicketItem.CreateTicket(ticketID, 1);
    }

    public static ItemStack CreateTicket(UUID ticketID, int count) {
        ItemStack ticket = new ItemStack((ItemLike)ModItems.TICKET, count);
        if (ticketID != null) {
            ticket.m_41784_().m_128362_("TicketID", ticketID);
        }
        return ticket;
    }

    public static MutableComponent getTicketMaterialsList() {
        TextComponent list = new TextComponent("");
        try {
            for (Item item : ForgeRegistries.ITEMS.tags().getTag(TICKET_MATERIAL_KEY).stream().collect(Collectors.toList())) {
                list.m_7220_((Component)new TextComponent("\n")).m_7220_(new ItemStack((ItemLike)item).m_41786_());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return list;
    }
}

