/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.menus.interfaces.ITraderMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.ITraderSource;
import io.github.lightman314.lightmanscurrency.trader.common.InteractionSlotData;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TraderMenu
extends AbstractContainerMenu
implements ITraderMenu {
    public final Supplier<ITraderSource> traderSource;
    public final Player player;
    public static final int SLOT_OFFSET = 15;
    InteractionSlot interactionSlot;
    Container coins = new SimpleContainer(5);
    List<Slot> coinSlots = new ArrayList<Slot>();

    public InteractionSlot getInteractionSlot() {
        return this.interactionSlot;
    }

    public Container getCoinInventory() {
        return this.coins;
    }

    public List<Slot> getCoinSlots() {
        return this.coinSlots;
    }

    public TraderMenu(int windowID, Inventory inventory, BlockPos sourcePosition) {
        this(ModMenus.TRADER, windowID, inventory, () -> {
            BlockEntity be = inventory.f_35978_.f_19853_.m_7702_(sourcePosition);
            if (be instanceof ITraderSource) {
                return (ITraderSource)be;
            }
            return null;
        });
    }

    protected TraderMenu(MenuType<?> type, int windowID, Inventory inventory, Supplier<ITraderSource> traderSource) {
        super(type, windowID);
        this.player = inventory.f_35978_;
        this.traderSource = traderSource;
        this.init(this.player, inventory);
        for (ITrader trader : this.traderSource.get().getTraders()) {
            if (trader == null) continue;
            trader.userOpen(this.player);
        }
    }

    public TradeContext getContext(ITrader trader) {
        return TradeContext.create(trader, this.player).withCoinSlots(this.coins).withInteractionSlot(this.interactionSlot).build();
    }

    protected void init(Player player, Inventory inventory) {
        int x;
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.m_38897_(new Slot((Container)inventory, x2 + y * 9 + 9, 23 + x2 * 18, 154 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        for (x = 0; x < this.coins.m_6643_(); ++x) {
            this.coinSlots.add(this.m_38897_(new CoinSlot(this.coins, x, 23 + (x + 4) * 18, 122)));
        }
        ArrayList<InteractionSlotData> slotData = new ArrayList<InteractionSlotData>();
        for (ITrader trader : this.traderSource.get().getTraders()) {
            trader.addInteractionSlots(slotData);
        }
        this.interactionSlot = new InteractionSlot(slotData, 23, 122);
        this.m_38897_(this.interactionSlot);
    }

    public boolean m_6875_(Player player) {
        return this.traderSource != null && this.traderSource.get() != null && this.traderSource.get().getTraders() != null && this.traderSource.get().getTraders().size() > 0;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.m_150411_(player, this.coins);
        this.m_150411_(player, this.interactionSlot.f_40218_);
        if (this.traderSource.get() != null) {
            for (ITrader trader : this.traderSource.get().getTraders()) {
                if (trader == null) continue;
                trader.userClose(this.player);
            }
        }
    }

    @Override
    public void ExecuteTrade(int traderIndex, int tradeIndex) {
        ITraderSource traderSource = this.traderSource.get();
        if (traderSource == null) {
            this.player.m_6915_();
            return;
        }
        List<ITrader> traderList = traderSource.getTraders();
        if (traderIndex >= 0 && traderIndex < traderList.size()) {
            ITrader trader = traderSource.getTraders().get(traderIndex);
            if (trader == null) {
                LightmansCurrency.LogWarning("Trader at index " + traderIndex + " is null.");
                return;
            }
            TradeContext.TradeResult result = trader.ExecuteTrade(this.getContext(trader), tradeIndex);
            if (result.hasMessage()) {
                LightmansCurrency.LogInfo(result.failMessage.getString());
            }
        } else {
            LightmansCurrency.LogWarning("Trader " + traderIndex + " is not a valid trader index.");
        }
    }

    public boolean isSingleTrader() {
        ITraderSource tradeSource = this.traderSource.get();
        if (tradeSource == null) {
            this.player.m_6915_();
            return false;
        }
        return tradeSource.isSingleTrader() && tradeSource.getTraders().size() == 1;
    }

    public ITrader getSingleTrader() {
        if (this.isSingleTrader()) {
            return this.traderSource.get().getSingleTrader();
        }
        return null;
    }

    public boolean isUniversalTrader() {
        return false;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index < 36 ? !this.m_38903_(slotStack, 36, this.f_38839_.size(), false) : index < this.f_38839_.size() && !this.m_38903_(slotStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    @Override
    public void CollectCoinStorage() {
        if (this.isSingleTrader()) {
            LightmansCurrency.LogInfo("Attempting to collect coins from trader.");
            ITrader trader = this.getSingleTrader();
            if (trader.hasPermission(this.player, "collectCoins")) {
                CoinValue payment = trader.getInternalStoredMoney();
                if (this.getContext(trader).givePayment(payment)) {
                    trader.clearStoredMoney();
                }
            } else {
                Settings.PermissionWarning(this.player, "collect stored coins", "collectCoins");
            }
        }
    }

    public static class TraderMenuAllUniversal
    extends TraderMenu {
        public TraderMenuAllUniversal(int windowID, Inventory inventory) {
            super(ModMenus.TRADER_UNIVERSAL_ALL, windowID, inventory, ITraderSource.UniversalTraderSource(inventory.f_35978_.f_19853_.f_46443_));
        }

        @Override
        public boolean isUniversalTrader() {
            return true;
        }
    }

    public static class TraderMenuUniversal
    extends TraderMenu {
        public TraderMenuUniversal(int windowID, Inventory inventory, UUID traderID) {
            super(ModMenus.TRADER_UNIVERSAL, windowID, inventory, () -> {
                if (inventory.f_35978_.f_19853_.f_46443_) {
                    return ClientTradingOffice.getData(traderID);
                }
                return TradingOffice.getData(traderID);
            });
        }

        @Override
        public boolean isUniversalTrader() {
            return true;
        }
    }
}

