/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdateTradeRule {
    private BlockPos pos;
    private int index;
    private ResourceLocation type;
    private CompoundTag updateInfo;

    public MessageUpdateTradeRule(BlockPos pos, ResourceLocation type, CompoundTag updateInfo) {
        this(pos, -1, type, updateInfo);
    }

    public MessageUpdateTradeRule(BlockPos pos, int index, ResourceLocation type, CompoundTag updateInfo) {
        this.pos = pos;
        this.index = index;
        this.type = type;
        this.updateInfo = updateInfo;
    }

    public static void encode(MessageUpdateTradeRule message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeInt(message.index);
        buffer.m_130070_(message.type.toString());
        buffer.m_130079_(message.updateInfo);
    }

    public static MessageUpdateTradeRule decode(FriendlyByteBuf buffer) {
        return new MessageUpdateTradeRule(buffer.m_130135_(), buffer.readInt(), new ResourceLocation(buffer.m_130277_()), buffer.m_130261_());
    }

    public static void handle(MessageUpdateTradeRule message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity be;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (be = player.f_19853_.m_7702_(message.pos)) instanceof ITradeRuleHandler.ITradeRuleMessageHandler) {
                ((ITradeRuleHandler.ITradeRuleMessageHandler)be).receiveTradeRuleMessage((Player)player, message.index, message.type, message.updateInfo);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

