/*
 * Decompiled with CFR 0.152.
 */
package net.mindoth.skillcloaks.item.cloak;

import java.util.List;
import javax.annotation.Nullable;
import net.mindoth.skillcloaks.curio.CurioItem;
import net.mindoth.skillcloaks.registries.SkillCloaksItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

@Mod.EventBusSubscriber(modid="skillcloaks")
public class PrayerCloakItem
extends CurioItem {
    private static final String TAG_HAS_PRAYER_CLOAK = "saveXp";

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("tooltip.skillcloaks.prayer_cloak"));
        super.m_7373_(stack, world, tooltip, flagIn);
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    @SubscribeEvent
    public static void onPlayerXpDrop(LivingExperienceDropEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.PRAYER_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLethal(LivingDamageEvent event) {
        LivingEntity player = event.getEntityLiving();
        CompoundTag playerData = player.getPersistentData();
        CompoundTag data = playerData.m_128469_("PlayerPersisted");
        if (event.getAmount() >= player.m_21223_() && (CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillCloaksItems.PRAYER_CLOAK.get()).isPresent() || CuriosApi.getCuriosHelper().findFirstCurio(player, (Item)SkillCloaksItems.MAX_CLOAK.get()).isPresent()) && !data.m_128471_(TAG_HAS_PRAYER_CLOAK)) {
            data.m_128379_(TAG_HAS_PRAYER_CLOAK, true);
            playerData.m_128365_("PlayerPersisted", (Tag)data);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        CompoundTag playerData;
        CompoundTag data;
        if (event.isWasDeath() && (data = (playerData = event.getOriginal().getPersistentData()).m_128469_("PlayerPersisted")).m_128471_(TAG_HAS_PRAYER_CLOAK) && event.getPlayer().f_36079_ <= 0) {
            event.getPlayer().m_6756_(event.getOriginal().f_36079_);
            data.m_128473_(TAG_HAS_PRAYER_CLOAK);
        }
    }
}

