/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.machines.core;

import com.mojang.brigadier.CommandDispatcher;
import dev.compactmods.machines.command.CMCommandRoot;
import dev.compactmods.machines.command.data.CMDataSubcommand;
import dev.compactmods.machines.core.Registration;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="compactmachines")
public class ServerEventHandler {
    @SubscribeEvent
    public static void onCommandsRegister(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        CMCommandRoot.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        CMDataSubcommand.make();
    }

    @SubscribeEvent
    public static void onWorldLoaded(WorldEvent.Load evt) {
        ServerLevel sl;
        LevelAccessor levelAccessor = evt.getWorld();
        if (levelAccessor instanceof ServerLevel && (sl = (ServerLevel)levelAccessor).m_46472_().equals(Registration.COMPACT_DIMENSION)) {
            MinecraftServer serv = sl.m_142572_();
            WorldBorder owBorder = serv.m_129783_().m_6857_();
            WorldBorder cwBorder = sl.m_6857_();
            Set listeners = owBorder.f_61905_.stream().filter(border -> border instanceof BorderChangeListener.DelegateBorderChangeListener).map(BorderChangeListener.DelegateBorderChangeListener.class::cast).filter(list -> list.f_61864_ == cwBorder).collect(Collectors.toSet());
            for (BorderChangeListener.DelegateBorderChangeListener listener : listeners) {
                owBorder.m_156096_((BorderChangeListener)listener);
            }
            cwBorder.m_61949_(0.0, 0.0);
            cwBorder.m_61917_(5.9999968E7);
            PacketDistributor.DIMENSION.with(() -> Registration.COMPACT_DIMENSION).send((Packet)new ClientboundSetBorderSizePacket(cwBorder));
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getPlayer();
        if (player.f_19853_.m_46472_().equals(Registration.COMPACT_DIMENSION) && player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_141995_((Packet)new ClientboundInitializeBorderPacket(new WorldBorder()));
        }
    }

    @SubscribeEvent
    public static void onPlayerDimChange(PlayerEvent.PlayerChangedDimensionEvent evt) {
        Player player;
        if (evt.getTo().equals(Registration.COMPACT_DIMENSION) && (player = evt.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            sp.f_8906_.m_141995_((Packet)new ClientboundInitializeBorderPacket(new WorldBorder()));
        }
    }
}

