/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.marg.client.generators.textures.generator.processors;

import com.mojang.datafixers.util.Pair;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureIntData;
import net.dark_roleplay.marg.client.generators.textures.generator.processors.TextureProcessorData;
import net.dark_roleplay.marg.client.generators.textures.texture.TextureData;

public class TextureProcessors {
    public static TextureData overlay(TextureData source, TextureProcessorData data) {
        TextureData input = data.getTexture().getTextureData()[data.getTextureDataIndex()];
        Pair<TextureData, TextureData> equalizedTextures = TextureProcessors.equalizeTextures(source, input);
        source = (TextureData)equalizedTextures.getFirst();
        input = (TextureData)equalizedTextures.getSecond();
        int width = source.getWidth();
        int height = source.getHeight();
        int[] srcPixel = new int[4];
        int[] inPixel = new int[4];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                source.getARGB(x, y, srcPixel);
                input.getARGB(x, y, inPixel);
                int a = inPixel[0] + srcPixel[0] * (255 - inPixel[0]) / 255;
                int r = inPixel[1] * inPixel[0] / 255 + srcPixel[1] * srcPixel[0] * (255 - inPixel[0]) / 65025;
                int g = inPixel[2] * inPixel[0] / 255 + srcPixel[2] * srcPixel[0] * (255 - inPixel[0]) / 65025;
                int b = inPixel[3] * inPixel[0] / 255 + srcPixel[3] * srcPixel[0] * (255 - inPixel[0]) / 65025;
                source.setPixel(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return source;
    }

    public static TextureData mask(TextureData source, TextureProcessorData data) {
        TextureData input = data.getTexture().getTextureData()[data.getTextureDataIndex()];
        Pair<TextureData, TextureData> equalizedTextures = TextureProcessors.equalizeTextures(source, input);
        source = (TextureData)equalizedTextures.getFirst();
        input = (TextureData)equalizedTextures.getSecond();
        int width = source.getWidth();
        int height = source.getHeight();
        int[] srcPixel = new int[4];
        int[] inPixel = new int[4];
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                source.getARGB(x, y, srcPixel);
                input.getARGB(x, y, inPixel);
                int a = srcPixel[0] & inPixel[0];
                int r = srcPixel[1] & inPixel[1];
                int g = srcPixel[2] & inPixel[2];
                int b = srcPixel[3] & inPixel[3];
                source.setPixel(x, y, a << 24 | r << 16 | g << 8 | b);
            }
        }
        return source;
    }

    public static TextureData rotate(TextureData source, TextureProcessorData data) {
        TextureData sourceCopy = source.clone();
        int rotations = ((TextureIntData)data).getValue();
        int width = source.getWidth();
        int height = source.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (rotations == 1) {
                    source.setPixel(x, y, sourceCopy.getPixel(height - y - 1, x));
                }
                if (rotations == 2) {
                    source.setPixel(x, y, sourceCopy.getPixel(width - x - 1, height - y - 1));
                }
                if (rotations != 3) continue;
                source.setPixel(x, y, sourceCopy.getPixel(width - x - 1, y));
            }
        }
        return source;
    }

    public static TextureData flip(TextureData source, TextureProcessorData data) {
        TextureData sourceCopy = source.clone();
        boolean xAxis = true;
        int width = source.getWidth();
        int height = source.getHeight();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                source.setPixel(x, y, sourceCopy.getPixel(xAxis ? width - 1 - x : x, xAxis ? y : height - 1 - y));
            }
        }
        return source;
    }

    private static Pair<TextureData, TextureData> equalizeTextures(TextureData source, TextureData input) {
        int srcWidth = source.getWidth();
        int srcHeight = source.getHeight();
        int inWidth = input.getWidth();
        int inHeight = input.getHeight();
        if (srcWidth > inWidth) {
            input = TextureProcessors.enlargeTexture(input, srcWidth / inWidth);
        } else if (srcWidth < inWidth) {
            source = TextureProcessors.enlargeTexture(source, inWidth / srcWidth);
            srcWidth = inWidth;
            srcHeight = inHeight;
        }
        return Pair.of((Object)source, (Object)input);
    }

    private static TextureData enlargeTexture(TextureData source, int factor) {
        int srcWidth = source.getWidth();
        int srcHeight = source.getHeight();
        TextureData worker = new TextureData(srcWidth * factor, srcHeight * factor);
        for (int x = 0; x < srcWidth; ++x) {
            for (int y = 0; y < srcHeight; ++y) {
                for (int x2 = 0; x2 < factor; ++x2) {
                    for (int y2 = 0; y2 < factor; ++y2) {
                        worker.setPixel(x * factor + x2, y * factor + y2, source.getPixel(x, y));
                    }
                }
            }
        }
        return worker;
    }
}

