/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.blocks;

import com.mrh0.buildersaddition.blocks.base.BaseDerivativeBlock;
import com.mrh0.buildersaddition.event.opts.BlockOptions;
import com.mrh0.buildersaddition.event.opts.ItemOptions;
import com.mrh0.buildersaddition.state.VerticalSlabState;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class VerticalSlab
extends BaseDerivativeBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<VerticalSlabState> TYPE = EnumProperty.m_61587_((String)"type", VerticalSlabState.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape WEST_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_SHAPE = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape SOUTH_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);

    public VerticalSlab(String name, Block source) {
        super(name + "_vertical_slab", source, new BlockOptions().setItemOptions(new ItemOptions().hide()));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VerticalSlabState.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VerticalSlab(String name, Block source, String mod) {
        super(name + "_vertical_slab", source, new BlockOptions());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VerticalSlabState.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return this.m_6843_(state, mirror.m_54846_(((VerticalSlabState)((Object)state.m_61143_(TYPE))).getFacing()));
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(TYPE, (Comparable)((Object)VerticalSlabState.reverseFacing(rotation.m_55954_(((VerticalSlabState)((Object)state.m_61143_(TYPE))).getFacing()), ((VerticalSlabState)((Object)state.m_61143_(TYPE))).isDouble())));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.m_6843_(state, direction);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        VerticalSlabState slabtype = (VerticalSlabState)((Object)state.m_61143_(TYPE));
        switch (slabtype) {
            case DOUBLEX: {
                return Shapes.m_83144_();
            }
            case DOUBLEZ: {
                return Shapes.m_83144_();
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return NORTH_SHAPE;
    }

    public boolean isTransparent(BlockState state) {
        return !((VerticalSlabState)((Object)state.m_61143_(TYPE))).isDouble();
    }

    private VerticalSlabState getDoubleState(VerticalSlabState s) {
        if (s == VerticalSlabState.EAST || s == VerticalSlabState.WEST) {
            return VerticalSlabState.DOUBLEX;
        }
        return VerticalSlabState.DOUBLEZ;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext c) {
        BlockPos blockpos = c.m_8083_();
        BlockState blockstate = c.m_43725_().m_8055_(blockpos);
        if (blockstate.m_60734_() == this) {
            return (BlockState)((BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)this.getDoubleState((VerticalSlabState)((Object)blockstate.m_61143_(TYPE)))))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState ifluidstate = c.m_43725_().m_6425_(blockpos);
        BlockState blockstate1 = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)((Object)VerticalSlabState.NORTH))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.m_76152_() == Fluids.f_76193_));
        Direction face = c.m_43719_();
        double flagdx = c.m_43720_().f_82479_ - (double)c.m_8083_().m_123341_() - 0.5;
        double flagdz = c.m_43720_().f_82481_ - (double)c.m_8083_().m_123343_() - 0.5;
        VerticalSlabState vss = VerticalSlabState.forFacings(face, c.m_8125_());
        if (flagdz > 0.0 && this.difg(flagdz, flagdx)) {
            vss = VerticalSlabState.SOUTH;
        }
        if (flagdz < 0.0 && this.difg(flagdz, flagdx)) {
            vss = VerticalSlabState.NORTH;
        }
        if (flagdx > 0.0 && this.difg(flagdx, flagdz)) {
            vss = VerticalSlabState.EAST;
        }
        if (flagdx < 0.0 && this.difg(flagdx, flagdz)) {
            vss = VerticalSlabState.WEST;
        }
        return (BlockState)blockstate1.m_61124_(TYPE, (Comparable)((Object)vss));
    }

    private boolean difg(double d1, double d2) {
        return Math.abs(d1) > Math.abs(d2);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext c) {
        ItemStack itemstack = c.m_43722_();
        VerticalSlabState slabtype = (VerticalSlabState)((Object)state.m_61143_(TYPE));
        if (slabtype != VerticalSlabState.DOUBLEX && slabtype != VerticalSlabState.DOUBLEZ && itemstack.m_41720_() == this.m_5456_()) {
            if (c.m_7058_()) {
                if (c.m_43719_() == Direction.NORTH && slabtype == VerticalSlabState.SOUTH) {
                    return true;
                }
                if (c.m_43719_() == Direction.EAST && slabtype == VerticalSlabState.WEST) {
                    return true;
                }
                if (c.m_43719_() == Direction.SOUTH && slabtype == VerticalSlabState.NORTH) {
                    return true;
                }
                return c.m_43719_() == Direction.WEST && slabtype == VerticalSlabState.EAST;
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.m_61143_(TYPE) != VerticalSlabState.DOUBLEX && state.m_61143_(TYPE) != VerticalSlabState.DOUBLEZ ? super.m_7361_(worldIn, pos, state, fluidStateIn) : false;
    }

    public boolean m_6044_(BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.m_61143_(TYPE) != VerticalSlabState.DOUBLEX && state.m_61143_(TYPE) != VerticalSlabState.DOUBLEZ ? super.m_6044_(worldIn, pos, state, fluidIn) : false;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            worldIn.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)worldIn));
        }
        return stateIn;
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        switch (type) {
            case LAND: {
                return false;
            }
            case WATER: {
                return world.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            }
            case AIR: {
                return false;
            }
        }
        return false;
    }
}

