/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.buildersaddition.network;

import com.mrh0.buildersaddition.network.IIntData;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class UpdateDataPacket {
    private BlockPos pos;
    private int data;

    public UpdateDataPacket(BlockPos pos, int data) {
        this.pos = pos;
        this.data = data;
    }

    public static void encode(UpdateDataPacket packet, FriendlyByteBuf tag) {
        tag.m_130064_(packet.pos);
        tag.writeInt(packet.data);
    }

    public static UpdateDataPacket decode(FriendlyByteBuf buf) {
        UpdateDataPacket scp = new UpdateDataPacket(buf.m_130135_(), buf.readInt());
        return scp;
    }

    public static void handle(UpdateDataPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            try {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    UpdateDataPacket.sendUpdate(pkt.pos, player, pkt.data);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void sendUpdate(BlockPos pos, ServerPlayer player, int data) {
        BlockEntity te = player.f_19853_.m_7702_(pos);
        if (te != null && te instanceof IIntData) {
            ((IIntData)te).updateData(data);
            Packet supdatetileentitypacket = te.m_183216_();
            if (supdatetileentitypacket != null) {
                player.f_8906_.m_141995_(supdatetileentitypacket);
            }
        }
    }
}

