/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks;

import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.PregenTaskQueue;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.TimedSubTask;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import java.time.Duration;
import java.time.LocalDateTime;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;

public class PrinterSubTask
extends TimedSubTask {
    private MinecraftServer server;
    private final PregenTaskQueue queue;
    private LocalDateTime old_time;
    private int old_chunks;

    public PrinterSubTask(PregenTaskQueue _queue) {
        this.queue = _queue;
    }

    @Override
    public void start() {
        super.start();
        this.old_time = LocalDateTime.now();
        this.old_chunks = 0;
    }

    @Override
    public void resume() {
        super.resume();
        this.old_time = LocalDateTime.now();
    }

    @Override
    int getDelay() {
        return ServerConfig.getPrintDelay();
    }

    @Override
    public void execute() {
        this.queue.getCurrentTask().ifPresent(task -> {
            LocalDateTime new_time = LocalDateTime.now();
            long duration = Duration.between(this.old_time, new_time).getSeconds();
            MutableComponent message = new TextComponent(String.format("pregen %s %d/%d(%d%%) %d chunks/s", DimensionHelper.getNameOfDim(task.getDimension()), task.getChunkIndex(), task.getChunkCount(), task.getProgress(), (long)Math.max(0, task.getChunkIndex() - this.old_chunks) / (duration == 0L ? 1L : duration))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
            if (ServerConfig.isSendFeedbackEnabled()) {
                this.server.m_6846_().m_11264_((Component)message, ChatType.SYSTEM, Util.f_137441_);
            } else {
                this.server.m_6352_((Component)message, Util.f_137441_);
            }
            this.old_time = new_time;
            this.old_chunks = task.getChunkIndex();
        });
    }

    public void setServer(MinecraftServer _server) {
        this.server = _server;
    }
}

