/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data;

import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import java.util.Optional;

class RegionPregenData {
    private final WorldPos start_gen_chunk_pos;
    private final int x_chunk_count;
    private int chunk_index = 0;
    private final int chunk_count;

    RegionPregenData(WorldPos region_pos, WorldPos start_chunk_pos, WorldPos end_chunk_pos) {
        WorldPos start_region_chunk_pos = new WorldPos(region_pos.getX() << 5, region_pos.getZ() << 5);
        WorldPos end_region_chunk_pos = new WorldPos(start_region_chunk_pos.getX() + 31, start_region_chunk_pos.getZ() + 31);
        this.start_gen_chunk_pos = new WorldPos(Math.max(start_chunk_pos.getX(), start_region_chunk_pos.getX()), Math.max(start_chunk_pos.getZ(), start_region_chunk_pos.getZ()));
        WorldPos end_gen_chunk_pos = new WorldPos(Math.min(end_chunk_pos.getX(), end_region_chunk_pos.getX()), Math.min(end_chunk_pos.getZ(), end_region_chunk_pos.getZ()));
        this.x_chunk_count = end_gen_chunk_pos.getX() - this.start_gen_chunk_pos.getX() + 1;
        int z_chunk_count = end_gen_chunk_pos.getZ() - this.start_gen_chunk_pos.getZ() + 1;
        this.chunk_count = this.x_chunk_count * z_chunk_count;
    }

    Optional<WorldPos> nextChunk() {
        if (this.isFullyGenerated()) {
            return Optional.empty();
        }
        WorldPos pos = new WorldPos(this.start_gen_chunk_pos.getX() + this.chunk_index % this.x_chunk_count, this.start_gen_chunk_pos.getZ() + this.chunk_index / this.x_chunk_count);
        ++this.chunk_index;
        return Optional.of(pos);
    }

    boolean isFullyGenerated() {
        return this.chunk_index >= this.chunk_count;
    }
}

