/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.CustomizableBlockEntity;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.misc.SCSounds;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class AlarmBlockEntity
extends CustomizableBlockEntity
implements ITickingBlockEntity {
    private Option.IntOption range;
    private Option.IntOption delay;
    private int cooldown;
    private boolean isPowered;

    public AlarmBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.ALARM_BLOCK_ENTITY.get(), pos, state);
        this.range = new Option.IntOption(() -> ((AlarmBlockEntity)this).m_58899_(), "range", 17, 0, (Integer)ConfigHandler.SERVER.maxAlarmRange.get(), 1, true);
        this.delay = new Option.IntOption(() -> ((AlarmBlockEntity)this).m_58899_(), "delay", 2, 1, 30, 1, true);
        this.cooldown = 0;
        this.isPowered = false;
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        if (this.isPowered && --this.cooldown <= 0) {
            double rangeSqr = Math.pow(((Integer)this.range.get()).intValue(), 2.0);
            for (ServerPlayer player : ((ServerLevel)level).m_8795_(p -> p.m_142538_().m_123331_((Vec3i)pos) <= rangeSqr)) {
                float volume = (float)(1.0 - player.m_142538_().m_123331_((Vec3i)pos) / rangeSqr);
                player.f_8906_.m_141995_((Packet)new ClientboundSoundPacket(SCSounds.ALARM.event, SoundSource.BLOCKS, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), volume, 1.0f));
            }
            this.setCooldown((Integer)this.delay.get() * 20);
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("cooldown", this.cooldown);
        tag.m_128379_("isPowered", this.isPowered);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.cooldown = tag.m_128451_("cooldown");
        this.isPowered = tag.m_128471_("isPowered");
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.m_6596_();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean isPowered) {
        this.isPowered = isPowered;
        this.m_6596_();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[0];
    }

    @Override
    public Option<?>[] customOptions() {
        return new Option[]{this.range, this.delay};
    }
}

