/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockChangeDetectorBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockChangeDetectorMenu;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.ClearChangeDetectorServer;
import net.geforcemods.securitycraft.network.server.SyncBlockChangeDetector;
import net.geforcemods.securitycraft.screen.components.CollapsibleTextList;
import net.geforcemods.securitycraft.screen.components.IToggleableButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.gui.ScrollPanel;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class BlockChangeDetectorScreen
extends AbstractContainerScreen<BlockChangeDetectorMenu>
implements ContainerListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("securitycraft:textures/gui/container/block_change_detector.png");
    private static final TranslatableComponent CLEAR = Utils.localize("gui.securitycraft:editModule.clear", new Object[0]);
    private static final TranslatableComponent BLOCK_NAME = Utils.localize(((Block)SCContent.BLOCK_CHANGE_DETECTOR.get()).m_7705_(), new Object[0]);
    private BlockChangeDetectorBlockEntity be;
    private ChangeEntryList changeEntryList;
    private TextHoverChecker[] hoverCheckers = new TextHoverChecker[3];
    private TextHoverChecker smartModuleHoverChecker;
    private ModeButton modeButton;
    private Checkbox showAllCheckbox;
    private BlockChangeDetectorBlockEntity.DetectionMode currentMode;

    public BlockChangeDetectorScreen(BlockChangeDetectorMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        menu.m_38893_(this);
        this.be = (BlockChangeDetectorBlockEntity)menu.be;
        this.f_97726_ = 200;
        this.f_97727_ = 256;
    }

    protected void m_7856_() {
        super.m_7856_();
        Button clearButton = (Button)this.m_142416_((GuiEventListener)new ExtendedButton(this.f_97735_ + 4, this.f_97736_ + 4, 8, 8, (Component)new TextComponent("x"), b -> {
            this.changeEntryList.allEntries.forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
            this.changeEntryList.allEntries.clear();
            this.changeEntryList.filteredEntries.clear();
            this.be.getEntries().clear();
            this.be.m_6596_();
            SecurityCraft.channel.sendToServer((Object)new ClearChangeDetectorServer(this.be.m_58899_()));
        }));
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, Locale.getDefault());
        boolean isOwner = this.be.getOwner().isOwner((Player)this.f_96541_.f_91074_);
        this.currentMode = this.be.getMode();
        this.modeButton = new ModeButton(this.f_97735_ + 173, this.f_97736_ + 19, 20, 20, this.currentMode.ordinal(), BlockChangeDetectorBlockEntity.DetectionMode.values().length, b -> {
            this.currentMode = BlockChangeDetectorBlockEntity.DetectionMode.values()[((ModeButton)b).getCurrentIndex()];
            this.changeEntryList.updateFilteredEntries();
        });
        this.m_142416_((GuiEventListener)this.modeButton);
        this.showAllCheckbox = new Checkbox(this.f_97735_ + 173, this.f_97736_ + 65, 20, 20, TextComponent.f_131282_, false, false){

            public void m_5691_() {
                super.m_5691_();
                BlockChangeDetectorScreen.this.changeEntryList.updateFilteredEntries();
            }
        };
        this.m_142416_((GuiEventListener)this.showAllCheckbox);
        this.hoverCheckers[0] = new TextHoverChecker((AbstractWidget)clearButton, (Component)CLEAR);
        this.hoverCheckers[1] = new TextHoverChecker((AbstractWidget)this.modeButton, Arrays.stream(BlockChangeDetectorBlockEntity.DetectionMode.values()).map(e -> Utils.localize(e.getDescriptionId(), new Object[0])).toList());
        this.hoverCheckers[2] = new TextHoverChecker((AbstractWidget)this.showAllCheckbox, (Component)Utils.localize("gui.securitycraft:block_change_detector.show_all_checkbox", new Object[0]));
        this.smartModuleHoverChecker = isOwner ? new TextHoverChecker(this.f_97736_ + 44, this.f_97736_ + 60, this.f_97735_ + 174, this.f_97735_ + 191, (Component)Utils.localize("gui.securitycraft:block_change_detector.smart_module_hint", new Object[0])) : null;
        this.changeEntryList = new ChangeEntryList(this.f_96541_, 160, 150, this.f_97736_ + 20, this.f_97735_ + 8);
        this.m_142416_((GuiEventListener)this.changeEntryList);
        clearButton.f_93623_ = this.modeButton.f_93623_ = isOwner;
        for (BlockChangeDetectorBlockEntity.ChangeEntry entry : this.be.getEntries()) {
            Object stateString = entry.state().m_61147_().size() > 0 ? "[" + entry.state().toString().split("\\[")[1].replace(",", ", ") : "";
            List list = List.of(entry.player(), entry.uuid(), entry.action(), Utils.getFormattedCoordinates(entry.pos()).getString(), stateString, dateFormat.format(new Date(entry.timestamp()))).stream().map(rec$ -> rec$.toString()).filter(s -> !s.isEmpty()).map(TextComponent::new).collect(Collectors.toList());
            this.changeEntryList.addEntry((ContentSavingCollapsileTextList)this.m_7787_((GuiEventListener)new ContentSavingCollapsileTextList(0, 0, 154, (Component)Utils.localize(entry.state().m_60734_().m_7705_(), new Object[0]), list, b -> this.changeEntryList.setOpen((ContentSavingCollapsileTextList)b), this.changeEntryList::isHovered, entry.action(), entry.state().m_60734_())));
        }
        ItemStack filteredStack = ((BlockChangeDetectorMenu)this.f_97732_).m_38853_(0).m_7993_();
        this.changeEntryList.filteredBlock = filteredStack.m_41619_() ? Blocks.f_50016_ : ((BlockItem)filteredStack.m_41720_()).m_40614_();
        this.changeEntryList.updateFilteredEntries();
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, (Component)BLOCK_NAME, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)BLOCK_NAME) / 2), 6.0f, 0x404040);
        this.m_7025_(pose, mouseX - this.f_97735_, mouseY - this.f_97736_);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
        super.m_6305_(pose, mouseX, mouseY, partialTick);
        for (TextHoverChecker hoverChecker : this.hoverCheckers) {
            if (hoverChecker == null || !hoverChecker.checkHover(mouseX, mouseY)) continue;
            this.m_96602_(pose, hoverChecker.getName(), mouseX, mouseY);
        }
        if (this.smartModuleHoverChecker != null && this.smartModuleHoverChecker.checkHover(mouseX, mouseY) && !this.be.isModuleEnabled(ModuleType.SMART)) {
            this.m_96597_(pose, this.smartModuleHoverChecker.getLines(), mouseX, mouseY);
        }
    }

    protected void m_7286_(PoseStack pose, float partialTick, int mouseX, int mouseY) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURE);
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.changeEntryList != null) {
            this.changeEntryList.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.changeEntryList != null) {
            this.changeEntryList.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.changeEntryList != null) {
            this.changeEntryList.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void m_7379_() {
        super.m_7379_();
        this.sendModeChangeToServer();
    }

    private void sendModeChangeToServer() {
        BlockChangeDetectorBlockEntity.DetectionMode mode = BlockChangeDetectorBlockEntity.DetectionMode.values()[this.modeButton.getCurrentIndex()];
        if (mode != this.be.getMode()) {
            this.be.setMode(mode);
            SecurityCraft.channel.sendToServer((Object)new SyncBlockChangeDetector(this.be.m_58899_(), mode));
        }
    }

    public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
        if (slotIndex == 0 && this.changeEntryList != null) {
            this.changeEntryList.filteredBlock = stack.m_41619_() ? Blocks.f_50016_ : ((BlockItem)stack.m_41720_()).m_40614_();
            this.changeEntryList.updateFilteredEntries();
        }
    }

    public void m_142153_(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    class ModeButton
    extends ExtendedButton
    implements IToggleableButton {
        private final ItemStack ironPickaxe;
        private final ItemStack grassBlock;
        private final int toggleCount;
        private int currentIndex;

        public ModeButton(int xPos, int yPos, int width, int height, int initialIndex, int toggleCount, Button.OnPress onPress) {
            super(xPos, yPos, width, height, TextComponent.f_131282_, onPress);
            this.ironPickaxe = new ItemStack((ItemLike)Items.f_42385_);
            this.grassBlock = new ItemStack((ItemLike)Blocks.f_50440_);
            this.currentIndex = 0;
            this.toggleCount = toggleCount;
            this.currentIndex = initialIndex;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTick) {
            super.m_6305_(pose, mouseX, mouseY, partialTick);
            if (this.currentIndex == BlockChangeDetectorBlockEntity.DetectionMode.BREAK.ordinal()) {
                BlockChangeDetectorScreen.this.f_96541_.m_91291_().m_115203_(this.ironPickaxe, this.f_93620_ + 2, this.f_93621_ + 2);
            } else if (this.currentIndex == BlockChangeDetectorBlockEntity.DetectionMode.PLACE.ordinal()) {
                BlockChangeDetectorScreen.this.f_96541_.m_91291_().m_115203_(this.grassBlock, this.f_93620_ + 2, this.f_93621_ + 2);
            } else if (this.currentIndex == BlockChangeDetectorBlockEntity.DetectionMode.BOTH.ordinal()) {
                BlockChangeDetectorScreen.this.f_96541_.m_91291_().m_174258_(this.grassBlock, this.f_93620_ + 2, this.f_93621_ + 2, 0, -100);
                BlockChangeDetectorScreen.this.f_96541_.m_91291_().m_115203_(this.ironPickaxe, this.f_93620_ + 2, this.f_93621_ + 2);
            }
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (Screen.m_96638_()) {
                this.setCurrentIndex(this.currentIndex - 1);
            } else {
                this.setCurrentIndex(this.currentIndex + 1);
            }
            super.m_5716_(mouseX, mouseY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            this.setCurrentIndex(this.currentIndex - (int)Math.signum(delta));
            this.f_93717_.m_93750_((Button)this);
            return true;
        }

        @Override
        public int getCurrentIndex() {
            return this.currentIndex;
        }

        @Override
        public void setCurrentIndex(int newIndex) {
            this.currentIndex = Math.floorMod(newIndex, this.toggleCount);
        }
    }

    class ChangeEntryList
    extends ScrollPanel {
        private final int slotHeight = 12;
        private List<ContentSavingCollapsileTextList> allEntries;
        private List<ContentSavingCollapsileTextList> filteredEntries;
        private ContentSavingCollapsileTextList currentlyOpen;
        private int contentHeight;
        private Block filteredBlock;

        public ChangeEntryList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left, 4, 6, 0, 0);
            this.slotHeight = 12;
            this.allEntries = new ArrayList<ContentSavingCollapsileTextList>();
            this.filteredEntries = new ArrayList<ContentSavingCollapsileTextList>();
            this.currentlyOpen = null;
            this.contentHeight = 0;
            this.filteredBlock = Blocks.f_50016_;
        }

        protected int getContentHeight() {
            return this.contentHeight;
        }

        public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
            int i;
            int height = 0;
            for (i = 0; i < this.filteredEntries.size(); ++i) {
                ContentSavingCollapsileTextList entry = this.filteredEntries.get(i);
                entry.f_93621_ = this.top + height - (int)this.scrollDistance;
                entry.f_93624_ = entry.f_93621_ + entry.m_93694_() > this.top && entry.f_93621_ < this.bottom;
                height += entry.m_93694_();
            }
            this.applyScrollLimits();
            super.m_6305_(pose, mouseX, mouseY, partialTicks);
            for (i = 0; i < this.filteredEntries.size(); ++i) {
                this.filteredEntries.get(i).renderLongMessageTooltip(pose);
            }
        }

        protected void drawPanel(PoseStack pose, int entryRight, int relativeY, Tesselator tesselator, int mouseX, int mouseY) {
            for (int i = 0; i < this.filteredEntries.size(); ++i) {
                this.filteredEntries.get(i).m_6305_(pose, mouseX, mouseY, 0.0f);
            }
        }

        public void addEntry(ContentSavingCollapsileTextList entry) {
            entry.m_93674_(154);
            entry.setHeight(12);
            entry.f_93620_ = this.left;
            entry.setY(this.top + 12 * this.allEntries.size());
            this.allEntries.add(entry);
        }

        public void setOpen(ContentSavingCollapsileTextList newOpenedTextList) {
            if (this.currentlyOpen == null) {
                this.currentlyOpen = newOpenedTextList;
            } else if (this.currentlyOpen == newOpenedTextList) {
                this.currentlyOpen = null;
            } else {
                this.currentlyOpen.switchOpenStatus();
                this.currentlyOpen = newOpenedTextList;
            }
            this.recalculateContentHeight();
        }

        public boolean isHovered(int mouseX, int mouseY) {
            return mouseX >= this.left && mouseY >= this.top && mouseX < this.right && mouseY < this.bottom;
        }

        private void applyScrollLimits() {
            int maxScroll = this.getContentHeight() - (this.height - this.border);
            if (maxScroll < 0) {
                maxScroll /= 2;
            }
            if (this.scrollDistance > (float)maxScroll) {
                this.scrollDistance = maxScroll;
            }
            if (this.scrollDistance < 0.0f) {
                this.scrollDistance = 0.0f;
            }
        }

        public void updateFilteredEntries() {
            this.allEntries.forEach(e -> {
                e.f_93623_ = false;
            });
            this.filteredEntries = !BlockChangeDetectorScreen.this.showAllCheckbox.m_93840_() ? new ArrayList<ContentSavingCollapsileTextList>(this.allEntries.stream().filter(e -> BlockChangeDetectorScreen.this.currentMode == BlockChangeDetectorBlockEntity.DetectionMode.BOTH || BlockChangeDetectorScreen.this.currentMode == e.getMode()).filter(e -> this.filteredBlock == Blocks.f_50016_ || this.filteredBlock == e.getBlock()).toList()) : new ArrayList<ContentSavingCollapsileTextList>(this.allEntries);
            this.filteredEntries.forEach(e -> {
                e.f_93623_ = true;
            });
            this.recalculateContentHeight();
        }

        public void recalculateContentHeight() {
            int height = this.filteredEntries.stream().reduce(0, (accumulated, ctl) -> accumulated + ctl.m_93694_(), (identity, accumulated) -> identity + accumulated);
            if (height < this.bottom - this.top - 8) {
                height = this.bottom - this.top - 8;
            }
            this.contentHeight = height;
            if (this.currentlyOpen != null) {
                this.scrollDistance = 12 * this.filteredEntries.indexOf((Object)this.currentlyOpen);
            }
            this.applyScrollLimits();
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (mouseY < (double)this.top || mouseY > (double)this.bottom) {
                return false;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double scroll) {
            if (this.getContentHeight() < this.height) {
                return false;
            }
            return super.m_6050_(mouseX, mouseY, scroll);
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
        }
    }

    class ContentSavingCollapsileTextList
    extends CollapsibleTextList {
        private final BlockChangeDetectorBlockEntity.DetectionMode mode;
        private final Block block;

        public ContentSavingCollapsileTextList(int xPos, int yPos, int width, Component displayString, List<? extends Component> textLines, Button.OnPress onPress, BiPredicate<Integer, Integer> extraHoverCheck, BlockChangeDetectorBlockEntity.DetectionMode mode, Block block) {
            super(xPos, yPos, width, displayString, textLines, onPress, extraHoverCheck);
            this.mode = mode;
            this.block = block;
        }

        public BlockChangeDetectorBlockEntity.DetectionMode getMode() {
            return this.mode;
        }

        public Block getBlock() {
            return this.block;
        }
    }
}

