/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ICustomizable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.Option;
import net.geforcemods.securitycraft.inventory.CustomizeBlockMenu;
import net.geforcemods.securitycraft.items.ModuleItem;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.ToggleModule;
import net.geforcemods.securitycraft.network.server.ToggleOption;
import net.geforcemods.securitycraft.network.server.UpdateSliderValue;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.PictureButton;
import net.geforcemods.securitycraft.screen.components.TextHoverChecker;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class CustomizeBlockScreen
extends AbstractContainerScreen<CustomizeBlockMenu>
implements IHasExtraAreas,
ContainerListener {
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("securitycraft:textures/gui/container/customize0.png"), new ResourceLocation("securitycraft:textures/gui/container/customize1.png"), new ResourceLocation("securitycraft:textures/gui/container/customize2.png"), new ResourceLocation("securitycraft:textures/gui/container/customize3.png"), new ResourceLocation("securitycraft:textures/gui/container/customize4.png"), new ResourceLocation("securitycraft:textures/gui/container/customize5.png")};
    private static final ResourceLocation BEACON_GUI = new ResourceLocation("textures/gui/container/beacon.png");
    private final List<Rect2i> extraAreas = new ArrayList<Rect2i>();
    private IModuleInventory moduleInv;
    private PictureButton[] descriptionButtons = new PictureButton[5];
    private AbstractWidget[] optionButtons = new AbstractWidget[5];
    private List<TextHoverChecker> hoverCheckers = new ArrayList<TextHoverChecker>();
    private final String blockName;
    private final TranslatableComponent name;
    private final int maxNumberOfModules;
    private EnumMap<ModuleType, Boolean> indicators = new EnumMap(ModuleType.class);

    public CustomizeBlockScreen(CustomizeBlockMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.moduleInv = menu.moduleInv;
        this.blockName = menu.moduleInv.getBlockEntity().m_58900_().m_60734_().m_7705_().substring(5);
        this.name = Utils.localize(this.moduleInv.getBlockEntity().m_58900_().m_60734_().m_7705_(), new Object[0]);
        this.maxNumberOfModules = this.moduleInv.getMaxNumberOfModules();
        menu.m_38893_(this);
        for (ModuleType type : ModuleType.values()) {
            if (this.moduleInv.hasModule(type)) {
                this.indicators.put(type, this.moduleInv.isModuleEnabled(type));
                continue;
            }
            this.indicators.put(type, true);
        }
    }

    public void m_7856_() {
        ICustomizable customizable;
        Option<?>[] options;
        super.m_7856_();
        int numberOfColumns = 2;
        for (int i = 0; i < this.maxNumberOfModules; ++i) {
            int column = i % 2;
            this.descriptionButtons[i] = new ModuleButton(this.f_97735_ + 127 + column * 22, this.f_97736_ + 16 + Math.floorDiv(i, 2) * 22, 20, 20, this.f_96542_, this.moduleInv.acceptedModules()[i].getItem(), this::moduleButtonClicked);
            this.m_142416_((GuiEventListener)this.descriptionButtons[i]);
            this.hoverCheckers.add(new TextHoverChecker((AbstractWidget)this.descriptionButtons[i], this.getModuleDescription(i)));
            this.descriptionButtons[i].f_93623_ = this.moduleInv.hasModule(this.moduleInv.acceptedModules()[i]);
        }
        BlockEntity column = this.moduleInv.getBlockEntity();
        if (column instanceof ICustomizable && (options = (customizable = (ICustomizable)column).customOptions()) != null) {
            for (int i = 0; i < options.length; ++i) {
                Option<?> option = options[i];
                if (option.isSlider()) {
                    if (option instanceof Option.DoubleOption) {
                        Option.DoubleOption doubleOption = (Option.DoubleOption)option;
                        this.optionButtons[i] = new CallbackSlider(this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, (Component)Utils.localize("option" + this.blockName + "." + option.getName(), ""), TextComponent.f_131282_, (Double)doubleOption.getMin(), (Double)doubleOption.getMax(), (Double)doubleOption.get(), (Double)doubleOption.getIncrement(), 0, true, slider -> {
                            doubleOption.setValue(slider.getValue());
                            SecurityCraft.channel.sendToServer((Object)new UpdateSliderValue(doubleOption.getPos(), option, (Double)doubleOption.get()));
                        });
                    } else if (option instanceof Option.IntOption) {
                        Option.IntOption intOption = (Option.IntOption)option;
                        this.optionButtons[i] = new CallbackSlider(this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, (Component)Utils.localize("option" + this.blockName + "." + option.getName(), ""), TextComponent.f_131282_, ((Integer)intOption.getMin()).intValue(), ((Integer)intOption.getMax()).intValue(), ((Integer)intOption.get()).intValue(), true, slider -> {
                            intOption.setValue(slider.getValueInt());
                            SecurityCraft.channel.sendToServer((Object)new UpdateSliderValue(intOption.getPos(), option, ((Integer)intOption.get()).intValue()));
                        });
                    }
                    this.optionButtons[i].setFGColor(0xE0E0E0);
                } else {
                    this.optionButtons[i] = new ExtendedButton(this.f_97735_ + 178, this.f_97736_ + 10 + i * 25, 120, 20, this.getOptionButtonTitle(option), this::optionButtonClicked);
                    this.optionButtons[i].setFGColor(option.toString().equals(option.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
                }
                this.m_142416_((GuiEventListener)this.optionButtons[i]);
                this.hoverCheckers.add(new TextHoverChecker(this.optionButtons[i], (Component)this.getOptionDescription(i)));
            }
        }
        for (AbstractWidget button : this.optionButtons) {
            if (button == null) continue;
            this.extraAreas.add(new Rect2i(button.f_93620_, button.f_93621_, button.m_5711_(), button.m_93694_()));
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        RenderSystem.m_157179_((int)0, (ResourceLocation)BEACON_GUI);
        for (int i = 36; i < ((CustomizeBlockMenu)this.f_97732_).maxSlots; ++i) {
            ModuleType type;
            Slot slot = (Slot)((CustomizeBlockMenu)this.f_97732_).f_38839_.get(i);
            if (slot.m_7993_().m_41619_() || !this.indicators.containsKey((Object)(type = ((ModuleItem)slot.m_7993_().m_41720_()).getModuleType()))) continue;
            CustomizeBlockScreen.m_93160_((PoseStack)pose, (int)(this.f_97735_ + slot.f_40220_ - 2), (int)(this.f_97736_ + slot.f_40221_ + 16), (int)20, (int)20, (float)(this.indicators.get((Object)type) != false ? 88.0f : 110.0f), (float)219.0f, (int)21, (int)22, (int)256, (int)256);
        }
        if (this.getSlotUnderMouse() != null && !this.getSlotUnderMouse().m_7993_().m_41619_()) {
            this.m_6057_(pose, this.getSlotUnderMouse().m_7993_(), mouseX, mouseY);
        }
        for (TextHoverChecker hoverChecker : this.hoverCheckers) {
            if (hoverChecker == null || !hoverChecker.checkHover(mouseX, mouseY) || hoverChecker.getWidget() instanceof CallbackSlider && this.m_7282_()) continue;
            this.m_96617_(pose, this.f_96541_.f_91062_.m_92923_((FormattedText)hoverChecker.getName(), 150), mouseX, mouseY);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, (Component)this.name, (float)(this.f_97726_ / 2 - this.f_96547_.m_92852_((FormattedText)this.name) / 2), 6.0f, 0x404040);
        this.f_96547_.m_92889_(pose, Utils.INVENTORY_TEXT, 8.0f, (float)(this.f_97727_ - 96 + 2), 0x404040);
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        this.m_7333_(pose);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157179_((int)0, (ResourceLocation)TEXTURES[this.maxNumberOfModules]);
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.m_7222_() != null && this.m_7282_() && button == 0 && this.m_7222_().m_7979_(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack stack) {
        if (slotIndex < 36) {
            return;
        }
        for (int i = 0; i < this.moduleInv.getMaxNumberOfModules(); ++i) {
            if (this.descriptionButtons[i] == null) continue;
            ModuleType type = this.moduleInv.acceptedModules()[i];
            this.descriptionButtons[i].f_93623_ = this.moduleInv.hasModule(type);
            if (!this.descriptionButtons[i].f_93623_) {
                this.indicators.remove((Object)type);
                continue;
            }
            if (this.indicators.containsKey((Object)type)) continue;
            this.indicators.put(type, true);
        }
    }

    private void moduleButtonClicked(Button button) {
        ModuleType moduleType = ((ModuleButton)button).getModule().getModuleType();
        if (this.moduleInv.isModuleEnabled(moduleType)) {
            this.indicators.put(moduleType, false);
            this.moduleInv.removeModule(moduleType, true);
        } else {
            this.indicators.put(moduleType, true);
            this.moduleInv.insertModule(this.moduleInv.getModule(moduleType), true);
        }
        SecurityCraft.channel.sendToServer((Object)new ToggleModule(this.moduleInv.getBlockEntity().m_58899_(), moduleType));
    }

    private void optionButtonClicked(Button button) {
        for (int i = 0; i < this.optionButtons.length; ++i) {
            if (button != this.optionButtons[i]) continue;
            Option<?> tempOption = ((ICustomizable)this.moduleInv.getBlockEntity()).customOptions()[i];
            tempOption.toggle();
            button.setFGColor(tempOption.toString().equals(tempOption.getDefaultValue().toString()) ? 0xFFFFA0 : 0xE0E0E0);
            button.m_93666_(this.getOptionButtonTitle(tempOption));
            SecurityCraft.channel.sendToServer((Object)new ToggleOption(this.moduleInv.getBlockEntity().m_58899_().m_123341_(), this.moduleInv.getBlockEntity().m_58899_().m_123342_(), this.moduleInv.getBlockEntity().m_58899_().m_123343_(), i));
            return;
        }
    }

    private Component getModuleDescription(int moduleId) {
        String moduleDescription = "module" + this.blockName + "." + this.descriptionButtons[moduleId].getItemStack().m_41778_().substring(5).replace("securitycraft.", "") + ".description";
        return Utils.localize(this.descriptionButtons[moduleId].getItemStack().m_41778_(), new Object[0]).m_7220_((Component)new TextComponent(":")).m_130940_(ChatFormatting.RESET).m_7220_((Component)new TextComponent("\n\n")).m_7220_((Component)Utils.localize(moduleDescription, new Object[0]));
    }

    private TranslatableComponent getOptionDescription(int optionId) {
        Option<?> option = ((ICustomizable)this.moduleInv.getBlockEntity()).customOptions()[optionId];
        String optionDescription = "option" + this.blockName + "." + option.getName() + ".description";
        return Utils.localize("gui.securitycraft:customize.tooltip", new TranslatableComponent(optionDescription), new TranslatableComponent("gui.securitycraft:customize.currentSetting", new Object[]{this.getValueText(option)}));
    }

    private Component getOptionButtonTitle(Option<?> option) {
        return Utils.localize("option" + this.blockName + "." + option.getName(), this.getValueText(option));
    }

    private Component getValueText(Option<?> option) {
        if (option instanceof Option.BooleanOption) {
            Option.BooleanOption booleanOption = (Option.BooleanOption)option;
            return new TranslatableComponent((Boolean)booleanOption.get() != false ? "gui.securitycraft:invScan.yes" : "gui.securitycraft:invScan.no");
        }
        return new TextComponent(option.toString());
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }

    public void m_142153_(AbstractContainerMenu menu, int slotIndex, int value) {
    }

    private class ModuleButton
    extends PictureButton {
        private final ModuleItem module;

        public ModuleButton(int xPos, int yPos, int width, int height, ItemRenderer itemRenderer, ModuleItem itemToRender, Button.OnPress onPress) {
            super(xPos, yPos, width, height, itemRenderer, new ItemStack((ItemLike)itemToRender), onPress);
            this.module = itemToRender;
        }

        public ModuleItem getModule() {
            return this.module;
        }
    }
}

