/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.config;

import com.yyon.grapplinghook.config.GrappleConfig;
import java.util.HashSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class GrappleConfigUtils {
    private static boolean anyBlocks = true;
    private static HashSet<Block> grapplingBlocks;
    private static boolean removeBlocks;
    private static HashSet<Block> grapplingBreaksBlocks;
    private static boolean anyBreakBlocks;
    private static String prevGrapplingBlocks;
    private static String prevGrapplingNonBlocks;
    private static String prevGrapplingBreakBlocks;

    public static HashSet<Block> stringToBlocks(String s) {
        String[] blockstr;
        HashSet<Block> blocks = new HashSet<Block>();
        if (s.equals("") || s.equals("none") || s.equals("any")) {
            return blocks;
        }
        for (String str : blockstr = s.split(",")) {
            String name;
            String modid;
            if ((str = str.trim()).contains(":")) {
                String[] splitstr = str.split(":");
                modid = splitstr[0];
                name = splitstr[1];
            } else {
                modid = "minecraft";
                name = str;
            }
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, name));
            blocks.add(b);
        }
        return blocks;
    }

    public static void updateGrapplingBlocks() {
        String s = GrappleConfig.getConf().grapplinghook.blocks.grapplingBlocks;
        if (s.equals("any") || s.equals("")) {
            s = GrappleConfig.getConf().grapplinghook.blocks.grapplingNonBlocks;
            if (s.equals("none") || s.equals("")) {
                anyBlocks = true;
            } else {
                anyBlocks = false;
                removeBlocks = true;
            }
        } else {
            anyBlocks = false;
            removeBlocks = false;
        }
        if (!anyBlocks) {
            grapplingBlocks = GrappleConfigUtils.stringToBlocks(s);
        }
        anyBreakBlocks = (grapplingBreaksBlocks = GrappleConfigUtils.stringToBlocks(GrappleConfig.getConf().grapplinghook.blocks.grappleBreakBlocks)).size() != 0;
    }

    public static boolean attachesBlock(Block block) {
        if (!GrappleConfig.getConf().grapplinghook.blocks.grapplingBlocks.equals(prevGrapplingBlocks) || !GrappleConfig.getConf().grapplinghook.blocks.grapplingNonBlocks.equals(prevGrapplingNonBlocks)) {
            GrappleConfigUtils.updateGrapplingBlocks();
        }
        if (anyBlocks) {
            return true;
        }
        boolean inlist = grapplingBlocks.contains(block);
        if (removeBlocks) {
            return !inlist;
        }
        return inlist;
    }

    public static boolean breaksBlock(Block block) {
        if (!GrappleConfig.getConf().grapplinghook.blocks.grappleBreakBlocks.equals(prevGrapplingBreakBlocks)) {
            GrappleConfigUtils.updateGrapplingBlocks();
        }
        if (!anyBreakBlocks) {
            return false;
        }
        return grapplingBreaksBlocks.contains(block);
    }

    public static Enchantment.Rarity getRarityFromInt(int rarity_int) {
        Enchantment.Rarity[] rarities = new Enchantment.Rarity[]{Enchantment.Rarity.VERY_RARE, Enchantment.Rarity.RARE, Enchantment.Rarity.UNCOMMON, Enchantment.Rarity.COMMON};
        if (rarity_int < 0) {
            rarity_int = 0;
        }
        if (rarity_int >= rarities.length) {
            rarity_int = rarities.length - 1;
        }
        return rarities[rarity_int];
    }

    static {
        removeBlocks = false;
        anyBreakBlocks = false;
        prevGrapplingBlocks = null;
        prevGrapplingNonBlocks = null;
        prevGrapplingBreakBlocks = null;
    }
}

