/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.network;

import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.core.ISyncableEntityCapability;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.network.ClientPacketHandler;
import com.yyon.grapplinghook.relocated.dev._100media.capabilitysyncer.network.EntityCapabilityStatusPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;

public class SimpleEntityCapabilityStatusPacket
extends EntityCapabilityStatusPacket {
    private static final Map<ResourceLocation, Function<Entity, ISyncableEntityCapability>> capRetrievers = new HashMap<ResourceLocation, Function<Entity, ISyncableEntityCapability>>();
    private final ResourceLocation capabilityId;

    public SimpleEntityCapabilityStatusPacket(int entityId, ResourceLocation capabilityId, CompoundTag tag) {
        super(entityId, tag);
        this.capabilityId = capabilityId;
    }

    public SimpleEntityCapabilityStatusPacket(int entityId, ResourceLocation capabilityId, ISyncableEntityCapability capability) {
        super(entityId, capability);
        this.capabilityId = capabilityId;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        super.write(buf);
        buf.m_130085_(this.capabilityId);
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        context.enqueueWork(() -> ClientPacketHandler.handleCapabilityStatus(this, capRetrievers.get(this.capabilityId)));
    }

    public static <T extends Entity> void register(ResourceLocation capabilityId, Function<T, ISyncableEntityCapability> capabilityRetriever, SimpleChannel channel, int id) {
        capRetrievers.put(capabilityId, capabilityRetriever);
        SimpleEntityCapabilityStatusPacket.register(channel, id, SimpleEntityCapabilityStatusPacket.class, buf -> SimpleEntityCapabilityStatusPacket.read(buf, (entityId, tag) -> new SimpleEntityCapabilityStatusPacket((int)entityId, buf.m_130281_(), (CompoundTag)tag)));
    }
}

