/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public interface IOutputSlot {
    public boolean canTakeFromOutputSlot(int var1, Player var2);

    @Nonnull
    public ItemStack shrinkStackSize(int var1, Player var2, int var3);

    public void onPickupFromOutputSlot(int var1, Player var2, ItemStack var3);

    public static class SlotOutput
    extends Slot {
        private final IOutputSlot callback;
        private Player player;

        public SlotOutput(Container inventory, int id, int x, int y, IOutputSlot callback) {
            super(inventory, id, x, y);
            this.callback = callback;
        }

        public void setClicked(Player player) {
            this.player = player;
        }

        public boolean m_5857_(ItemStack itemStack) {
            return false;
        }

        public boolean m_8010_(Player player) {
            return this.callback == null || this.callback.canTakeFromOutputSlot(this.getSlotIndex(), player);
        }

        public void m_142406_(Player player, ItemStack stack) {
            if (this.callback != null) {
                this.callback.onPickupFromOutputSlot(this.getSlotIndex(), player, stack);
            }
            this.m_6654_();
        }

        @Nonnull
        public ItemStack m_6201_(int amount) {
            if (this.player != null && this.callback != null) {
                ItemStack stack = this.callback.shrinkStackSize(this.getSlotIndex(), this.player, amount);
                this.player = null;
                if (!stack.m_41619_()) {
                    return stack;
                }
            }
            return super.m_6201_(amount);
        }
    }
}

