/*
 * Decompiled with CFR 0.152.
 */
package net.mrscauthd.beyond_earth.gauge;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.mrscauthd.beyond_earth.capabilities.oxygen.IOxygenStorage;
import net.mrscauthd.beyond_earth.gauge.GaugeValueFluidStack;
import net.mrscauthd.beyond_earth.gauge.GaugeValueSimple;
import net.mrscauthd.beyond_earth.gauge.IGaugeValue;
import net.mrscauthd.beyond_earth.machines.tile.AbstractMachineBlockEntity;
import net.mrscauthd.beyond_earth.machines.tile.PowerSystemFuelBurnTime;

public class GaugeValueHelper {
    public static final ResourceLocation ENERGY_NAME = new ResourceLocation("beyond_earth", "energy");
    public static final ResourceLocation OXYGEN_NAME = new ResourceLocation("beyond_earth", "oxygen");
    public static final ResourceLocation FLUID_NAME = new ResourceLocation("beyond_earth", "fluid");
    public static final ResourceLocation FUEL_NAME = new ResourceLocation("beyond_earth", "fuel");
    public static final ResourceLocation BURNTIME_NAME = new ResourceLocation("beyond_earth", "burntime");
    public static final ResourceLocation COOKTIME_NAME = new ResourceLocation("beyond_earth", "cooktime");
    public static final int ENERGY_COLOR = -1593884597;
    public static final int OXYGEN_COLOR = -1610547201;
    public static final int FUEL_COLOR = -1600546499;
    public static final int BURNTIME_COLOR = -1593884928;
    public static final int COOKTIME_COLOR = -1593835521;
    public static final String ENERGY_UNIT = "FE";
    public static final String OXYGEN_UNIT = "mB";
    public static final String FLUID_UNIT = "mB";

    public static String makeTranslationKey(ResourceLocation name) {
        return "gauge." + name.m_135827_() + "." + name.m_135815_();
    }

    public static IGaugeValue getFluid(int amount) {
        return GaugeValueHelper.getFluid(amount, 0);
    }

    public static IGaugeValue getFluid(int amount, int capacity) {
        return new GaugeValueSimple(FLUID_NAME, amount, capacity, null, "mB");
    }

    public static IGaugeValue getFluid(Fluid fluid, int amount) {
        return GaugeValueHelper.getFluid(new FluidStack(fluid, amount));
    }

    public static IGaugeValue getFluid(Fluid fluid, int amount, int capacity) {
        return GaugeValueHelper.getFluid(new FluidStack(fluid, amount), capacity);
    }

    public static IGaugeValue getFluid(FluidStack stack) {
        return GaugeValueHelper.getFluid(stack, 0);
    }

    public static IGaugeValue getFluid(FluidStack stack, int capacity) {
        return new GaugeValueFluidStack(stack, capacity);
    }

    public static IGaugeValue getFluid(IFluidTank tank) {
        return GaugeValueHelper.getFluid(tank.getFluid(), tank.getCapacity());
    }

    public static IGaugeValue getEnergy(int amount) {
        return GaugeValueHelper.getEnergy(amount, 0);
    }

    public static IGaugeValue getEnergy(int stored, int capacity) {
        return new GaugeValueSimple(ENERGY_NAME, stored, capacity, null, ENERGY_UNIT).color(-1593884597);
    }

    public static IGaugeValue getEnergy(IEnergyStorage energyStorage) {
        return GaugeValueHelper.getEnergy(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored());
    }

    public static IGaugeValue getEnergy(AbstractMachineBlockEntity blockEntity) {
        return GaugeValueHelper.getEnergy(blockEntity.getPrimaryEnergyStorage());
    }

    public static IGaugeValue getOxygen(int amount) {
        return GaugeValueHelper.getOxygen(amount, 0);
    }

    public static IGaugeValue getOxygen(int amount, int capacity) {
        return new GaugeValueSimple(OXYGEN_NAME, amount, capacity, null, "mB").color(-1610547201);
    }

    public static IGaugeValue getOxygen(IOxygenStorage oxygenStorage) {
        return GaugeValueHelper.getOxygen(oxygenStorage.getOxygenStored(), oxygenStorage.getMaxOxygenStored());
    }

    public static IGaugeValue getBurnTime(int amount) {
        return GaugeValueHelper.getBurnTime(amount, 0);
    }

    public static IGaugeValue getBurnTime(int amount, int capacity) {
        return new GaugeValueSimple(BURNTIME_NAME, amount, capacity).color(-1593884928);
    }

    public static IGaugeValue getBurnTime(PowerSystemFuelBurnTime fuelPowerSystem) {
        return GaugeValueHelper.getBurnTime(fuelPowerSystem.getStored(), fuelPowerSystem.getCapacity());
    }

    public static IGaugeValue getCookTime(int timer, int maxTimer) {
        return new GaugeValueSimple(COOKTIME_NAME, maxTimer - timer, maxTimer).color(-1593835521).reverse(true);
    }

    public static IGaugeValue getFuel(int amount) {
        return GaugeValueHelper.getFuel(amount, 0);
    }

    public static IGaugeValue getFuel(int amount, int capacity) {
        return new GaugeValueSimple(FUEL_NAME, amount, capacity, null, "mB").color(-1600546499);
    }
}

