/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.data.INBTSerializable;
import com.endertech.minecraft.forge.data.INetSerializable;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.DimensionId;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.LevelChunk;

public class ChunkLoc
implements INetSerializable<ChunkLoc>,
INBTSerializable<ChunkLoc> {
    public static final ChunkLoc ZERO = new ChunkLoc(DimensionId.from((ResourceKey<Level>)Level.f_46428_), new ChunkPos(0, 0));
    private final DimensionId dimensionId;
    private final ChunkPos pos;

    public ChunkLoc(DimensionId dimensionId, ChunkPos pos) {
        this.pos = pos;
        this.dimensionId = dimensionId;
    }

    public static ChunkLoc from(Level world, ChunkPos pos) {
        return new ChunkLoc(DimensionId.from(world), pos);
    }

    public static ChunkLoc from(LevelChunk chunk) {
        return ChunkLoc.from(chunk.m_62953_(), chunk.m_7697_());
    }

    public DimensionId getDimensionId() {
        return this.dimensionId;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public ChunkBounds getBounds(LevelHeightAccessor level) {
        return ChunkBounds.from(level, this.getPos());
    }

    public boolean existsIn(Level world) {
        return world.m_7232_(this.getPos().f_45578_, this.getPos().f_45579_);
    }

    public Optional<LevelChunk> getChunk(Level world) {
        return this.existsIn(world) ? Optional.of(world.m_6325_(this.getPos().f_45578_, this.getPos().f_45579_)) : Optional.empty();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkLoc) {
            ChunkLoc that = (ChunkLoc)obj;
            return this.getDimensionId().equals(that.getDimensionId()) && this.getPos().equals((Object)that.getPos());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getDimensionId());
    }

    public boolean contains(Entity entity) {
        Level level = entity.m_183503_();
        return this.getDimensionId().belongsTo(level) && this.getBounds((LevelHeightAccessor)level).encloses(entity.m_142538_());
    }

    public String toString() {
        return ChunkLoc.class.getSimpleName() + Args.group(Args.get("pos", this.getPos()), Args.get("dimensionId", this.getDimensionId()));
    }

    @Override
    public ChunkLoc readFrom(FriendlyByteBuf buf) {
        return new ChunkLoc(DimensionId.from(buf.m_130281_()), new ChunkPos(buf.readInt(), buf.readInt()));
    }

    @Override
    public FriendlyByteBuf writeTo(FriendlyByteBuf buf) {
        buf.m_130085_(this.getDimensionId().toResourceLocation());
        buf.writeInt(this.getPos().f_45578_);
        buf.writeInt(this.getPos().f_45579_);
        return buf;
    }

    @Override
    public ChunkLoc readFrom(CompoundTag compound) {
        CompoundTag tag = compound.m_128469_("ChunkLoc");
        DimensionId id = DimensionId.from(new ResourceLocation(tag.m_128461_("id")));
        ChunkPos pos = new ChunkPos(tag.m_128454_("pos"));
        return new ChunkLoc(id, pos);
    }

    @Override
    public CompoundTag writeTo(CompoundTag compound) {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.getDimensionId().toResourceLocation().toString());
        tag.m_128356_("pos", this.getPos().m_45588_());
        compound.m_128365_("ChunkLoc", (Tag)tag);
        return compound;
    }
}

