/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.server.network;

import io.github.kosmx.emotes.api.Pair;
import io.github.kosmx.emotes.common.emote.EmoteData;
import java.time.Duration;
import java.time.Instant;
import javax.annotation.Nullable;

public class EmotePlayTracker {
    private EmoteData currentEmote = null;
    private Instant startTime = null;
    private boolean isForced = false;

    public void setPlayedEmote(@Nullable EmoteData data, boolean isForced) {
        this.currentEmote = data;
        if (data == null) {
            this.startTime = null;
            isForced = false;
        } else {
            this.startTime = Instant.now();
        }
    }

    public boolean isForced() {
        if (this.getPlayedEmote() != null) {
            return this.isForced;
        }
        return false;
    }

    @Nullable
    public Pair<EmoteData, Integer> getPlayedEmote() {
        if (this.currentEmote == null) {
            return null;
        }
        Instant now = Instant.now();
        int tick = (int)(Duration.between(this.startTime, Instant.now()).toMillis() / 50L);
        if (!this.currentEmote.isInfinite() && this.currentEmote.getLength() <= tick) {
            this.currentEmote = null;
            this.startTime = null;
            this.isForced = false;
            return null;
        }
        return new Pair<EmoteData, Integer>(this.currentEmote, tick);
    }
}

