/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.pavocado.exoticbirds.entity.PelicanEntity;

@OnlyIn(value=Dist.CLIENT)
public class PelicanModel<T extends PelicanEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation PELICAN_LAYER = new ModelLayerLocation(new ResourceLocation("exoticbirds", "pelican"), "main");
    private final ModelPart body;
    private final ModelPart breast;
    private final ModelPart lowerTail;
    private final ModelPart upperTail;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart lowerBeak;
    private final ModelPart upperBeak;
    private final ModelPart backBody;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart leftFoot;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart rightFoot;
    private final ModelPart leftLegRing;

    public PelicanModel(ModelPart part) {
        this.body = part.m_171324_("body");
        this.breast = part.m_171324_("breast");
        this.lowerTail = part.m_171324_("lowerTail");
        this.upperTail = part.m_171324_("upperTail");
        this.neck = part.m_171324_("neck");
        this.head = part.m_171324_("head");
        this.lowerBeak = part.m_171324_("lowerBeak");
        this.upperBeak = part.m_171324_("upperBeak");
        this.backBody = part.m_171324_("backBody");
        this.rightWing = part.m_171324_("rightWing");
        this.leftWing = part.m_171324_("leftWing");
        this.leftFoot = part.m_171324_("leftFoot");
        this.leftLeg = part.m_171324_("leftLeg");
        this.rightLeg = part.m_171324_("rightLeg");
        this.rightFoot = part.m_171324_("rightFoot");
        this.leftLegRing = part.m_171324_("leftLegRing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-3.0f, -3.5f, 0.0f, 6.0f, 6.0f, 5.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("breast", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171481_(-2.0f, -3.0f, -2.0f, 4.0f, 4.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-4.0f, (float)-0.3141593f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerTail", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171481_(-2.0f, -0.2f, -1.0f, 4.0f, 2.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)4.0f, (float)-0.0872665f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperTail", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171481_(-1.5f, -1.1f, -2.0f, 3.0f, 1.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)4.0f, (float)-0.2230717f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(40, 0).m_171481_(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-4.0f, (float)-0.2974289f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(22, 9).m_171481_(-1.5f, -8.0f, -0.25f, 3.0f, 3.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-4.0f, (float)0.122173f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("lowerBeak", CubeListBuilder.m_171558_().m_171514_(36, 9).m_171481_(-0.5f, -5.2f, -6.5f, 1.0f, 2.0f, 7.0f), PartPose.m_171423_((float)0.0f, (float)16.1f, (float)-4.0f, (float)-0.17453294f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("upperBeak", CubeListBuilder.m_171558_().m_171514_(48, 0).m_171481_(-1.0f, -7.0f, -5.5f, 2.0f, 2.0f, 6.0f), PartPose.m_171423_((float)0.0f, (float)16.0f, (float)-4.0f, (float)0.1396263f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("backBody", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171481_(-2.5f, -3.5f, 4.5f, 5.0f, 5.0f, 4.0f), PartPose.m_171423_((float)0.0f, (float)18.0f, (float)-4.0f, (float)-0.1396263f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(20, 16).m_171481_(-0.5f, -1.0f, 0.0f, 1.0f, 6.0f, 10.0f), PartPose.m_171423_((float)-3.5f, (float)16.0f, (float)-4.0f, (float)0.1396263f, (float)0.1047198f, (float)0.0872665f));
        partdefinition.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(42, 16).m_171481_(-0.5f, -1.0f, 0.0f, 1.0f, 6.0f, 10.0f), PartPose.m_171423_((float)3.5f, (float)16.0f, (float)-4.0f, (float)0.1396263f, (float)-0.1047198f, (float)-0.0872665f));
        partdefinition.m_171599_("leftFoot", CubeListBuilder.m_171558_().m_171514_(35, 22).m_171481_(-1.5f, 4.0f, -3.5f, 3.0f, 0.0f, 4.0f), PartPose.m_171423_((float)1.5f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(33, 20).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)1.5f, (float)20.0f, (float)0.0f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(47, 20).m_171481_(-0.5f, 0.0f, -0.5f, 1.0f, 4.0f, 1.0f), PartPose.m_171423_((float)-1.5f, (float)20.0f, (float)0.0f, (float)-0.0523599f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("rightFoot", CubeListBuilder.m_171558_().m_171514_(35, 18).m_171481_(-1.5f, 4.0f, -3.5f, 3.0f, 0.0f, 4.0f), PartPose.m_171423_((float)-1.5f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        partdefinition.m_171599_("leftLegRing", CubeListBuilder.m_171558_().m_171514_(49, 9).m_171481_(-1.05f, 1.0f, -1.0f, 2.0f, 2.0f, 2.0f), PartPose.m_171423_((float)1.5f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.neck, (Object)this.head, (Object)this.lowerBeak, (Object)this.upperBeak);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.breast, (Object)this.lowerTail, (Object)this.upperTail, (Object)this.backBody, (Object)this.rightWing, (Object)this.leftWing, (Object)this.leftFoot, (Object)this.leftLeg, (Object)this.rightLeg, (Object)this.rightFoot, (Object)this.leftLegRing, (Object[])new ModelPart[0]);
    }

    public void setupAnim(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entityIn.m_20069_() || entityIn.m_21825_()) {
            this.body.m_104227_(0.0f, 18.0f, -4.0f);
            this.breast.m_104227_(0.0f, 18.0f, -4.0f);
            this.lowerTail.m_104227_(0.0f, 18.0f, 4.0f);
            this.upperTail.m_104227_(0.0f, 18.0f, 4.0f);
            this.neck.m_104227_(0.0f, 16.0f, -4.0f);
            this.head.m_104227_(0.0f, 16.0f, -4.0f);
            this.lowerBeak.m_104227_(0.0f, 16.1f, -4.0f);
            this.upperBeak.m_104227_(0.0f, 16.0f, -4.0f);
            this.backBody.m_104227_(0.0f, 18.0f, -4.0f);
            this.rightWing.m_104227_(-3.5f, 16.0f, -4.0f);
            this.leftWing.m_104227_(3.5f, 16.0f, -4.0f);
            this.body.f_104203_ = 0.0f;
            this.breast.f_104203_ = -0.3141593f;
            this.lowerTail.f_104203_ = -0.0872665f;
            this.upperTail.f_104203_ = -0.2230717f;
            this.backBody.f_104203_ = -0.1396263f;
            this.rightWing.f_104203_ = 0.1396263f;
            this.leftWing.f_104203_ = 0.1396263f;
        } else {
            this.body.m_104227_(0.0f, 16.0f, -3.0f);
            this.breast.m_104227_(0.0f, 17.0f, -3.0f);
            this.lowerTail.m_104227_(0.0f, 20.5f, 3.5f);
            this.upperTail.m_104227_(0.0f, 21.5f, 4.0f);
            this.neck.m_104227_(0.0f, 15.0f, -3.0f);
            this.head.m_104227_(0.0f, 15.0f, -3.0f);
            this.lowerBeak.m_104227_(0.0f, 15.1f, -3.0f);
            this.upperBeak.m_104227_(0.0f, 15.0f, -3.0f);
            this.backBody.m_104227_(0.0f, 16.0f, -3.0f);
            this.rightWing.m_104227_(-3.5f, 14.0f, -2.0f);
            this.leftWing.m_104227_(3.5f, 14.0f, -2.0f);
            this.body.f_104203_ = -0.6981317f;
            this.breast.f_104203_ = -0.3141593f;
            this.lowerTail.f_104203_ = -0.8203047f;
            this.upperTail.f_104203_ = -0.7330383f;
            this.backBody.f_104203_ = -0.837758f;
            this.rightWing.f_104203_ = -0.5585054f;
            this.leftWing.f_104203_ = -0.5585054f;
        }
        this.head.f_104203_ = -(headPitch / 57.295776f) + 0.112173f;
        this.lowerBeak.f_104204_ = this.head.f_104204_ = netHeadYaw / 57.295776f;
        this.lowerBeak.f_104203_ = -(headPitch / 57.295776f) - 0.17453294f;
        this.upperBeak.f_104204_ = this.head.f_104204_;
        this.upperBeak.f_104203_ = -(headPitch / 57.295776f) + 0.1396263f;
        this.neck.f_104204_ = this.head.f_104204_;
        this.neck.f_104203_ = -(headPitch / 57.295776f) - 0.2974289f;
        this.rightWing.f_104205_ = ageInTicks;
        this.leftWing.f_104205_ = -ageInTicks;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.rightFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftLegRing.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFoot.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFoot.f_104204_ = 0.0f;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftFoot.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        this.leftLegRing.f_104204_ = 0.0f;
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            stack.m_85836_();
            stack.m_85841_(0.7f, 0.7f, 0.7f);
            stack.m_85837_(0.0, (double)0.6f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        } else {
            stack.m_85836_();
            stack.m_85841_(1.1f, 1.1f, 1.1f);
            stack.m_85837_(0.0, (double)-0.18f, 0.0);
            this.m_5607_().forEach(p_102061_ -> p_102061_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            this.m_5608_().forEach(p_102051_ -> p_102051_.m_104306_(stack, builder, packedLight, packedOverlay, red, green, blue, alpha));
            stack.m_85849_();
        }
    }
}

