/*
 * Decompiled with CFR 0.152.
 */
package net.pavocado.exoticbirds.network;

import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.pavocado.exoticbirds.entity.AbstractBirdEntity;

public class PacketLogBird {
    private final int entityId;
    private final boolean isNewEntry;

    public PacketLogBird(int entityId, boolean isNewEntry) {
        this.entityId = entityId;
        this.isNewEntry = isNewEntry;
    }

    public static void encode(PacketLogBird message, FriendlyByteBuf buffer) {
        buffer.writeInt(message.entityId);
        buffer.writeBoolean(message.isNewEntry);
    }

    public static PacketLogBird decode(FriendlyByteBuf buffer) {
        return new PacketLogBird(buffer.readInt(), buffer.readBoolean());
    }

    public static void handle(PacketLogBird packet, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> PacketLogBird.handleOnClient(packet)));
        contextSupplier.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleOnClient(PacketLogBird packet) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Entity entity = player.f_19853_.m_6815_(packet.entityId);
            PacketLogBird.displayLoggedBirdInfo(player, entity, packet.isNewEntry);
        }
    }

    static void displayLoggedBirdInfo(LocalPlayer player, Entity entity, boolean isNewEntry) {
        if (entity instanceof AbstractBirdEntity) {
            AbstractBirdEntity birdEntity = (AbstractBirdEntity)entity;
            String variantName = birdEntity.m_7755_().getString();
            if (isNewEntry) {
                player.m_6352_((Component)new TranslatableComponent("book.exoticbirds.log_new", new Object[]{variantName.toLowerCase()}).m_130940_(ChatFormatting.AQUA), Util.f_137441_);
            } else {
                player.m_6352_((Component)new TranslatableComponent("book.exoticbirds.log_old", new Object[]{variantName}).m_130940_(ChatFormatting.GRAY), Util.f_137441_);
            }
            BaseComponent speciesName = birdEntity.getTranslatedVariantName(birdEntity.currentVariant(), false);
            player.m_6352_((Component)new TranslatableComponent("book.exoticbirds.log_species", new Object[]{speciesName}).m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC), Util.f_137441_);
        }
    }
}

