/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.justutilities.physics.collision;

import net.dark_roleplay.justutilities.physics.collision.CollissionInformation;
import net.dark_roleplay.justutilities.physics.collision.IBoundingBox;
import net.minecraft.world.phys.Vec3;

public class CollisionChecker {
    public static CollissionInformation checkCollision(IBoundingBox a, IBoundingBox b) {
        Vec3[] axes = a.getCollisionAxes(b);
        CollissionInformation info = CollisionChecker.hasOverlap(axes, b.getVerts(), a.getVerts());
        return info != null ? info : CollisionChecker.hasOverlap(axes, a.getVerts(), b.getVerts());
    }

    private static CollissionInformation hasOverlap(Vec3[] axes, Vec3[] bVerts, Vec3[] aVerts) {
        double minOverlap = Double.POSITIVE_INFINITY;
        Vec3 smallestAxis = null;
        for (int i = 0; i < axes.length; ++i) {
            double maxs;
            double val;
            int j;
            double bProjMin = 3.4028234663852886E38;
            double aProjMin = 3.4028234663852886E38;
            double bProjMax = 1.4E-45f;
            double aProjMax = 1.4E-45f;
            Vec3 axis = axes[i];
            if (axis == Vec3.f_82478_) continue;
            for (j = 0; j < bVerts.length; ++j) {
                val = bVerts[j].m_82526_(axis);
                if (val < bProjMin) {
                    bProjMin = val;
                }
                if (!(val > bProjMax)) continue;
                bProjMax = val;
            }
            for (j = 0; j < bVerts.length; ++j) {
                val = aVerts[j].m_82526_(axis);
                if (val < aProjMin) {
                    aProjMin = val;
                }
                if (!(val > aProjMax)) continue;
                aProjMax = val;
            }
            double overlap = CollisionChecker.getIntervalOverlap(aProjMin, aProjMax, bProjMin, bProjMax);
            double mins = Math.abs(aProjMin - bProjMin);
            if (mins > (maxs = Math.abs(aProjMax - bProjMax))) {
                axis = axis.m_82548_();
            }
            if (overlap < minOverlap) {
                minOverlap = overlap;
                smallestAxis = axis;
            }
            if (!(overlap <= 0.0)) continue;
            return null;
        }
        return new CollissionInformation(smallestAxis, minOverlap);
    }

    private static double getIntervalOverlap(double a1, double a2, double b1, double b2) {
        return a1 < b1 ? (a2 < b1 ? 0.0 : a2 - b1) : (b2 < a1 ? 0.0 : b2 - a1);
    }
}

