/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.experimental_features.builtin_mixed_model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dark_roleplay.projectbrazier.experimental_features.builtin_mixed_model.BuiltinMixedModelData;
import net.dark_roleplay.projectbrazier.experimental_features.builtin_mixed_model.IQuadProvider;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;

public class BuiltinMixedModel
implements IModelGeometry<BuiltinMixedModel> {
    private final UnbakedModel originalModel;

    private BuiltinMixedModel(UnbakedModel originalModel) {
        this.originalModel = originalModel;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new BuiltinMixedBakedModel(this.originalModel.m_7611_(bakery, spriteGetter, modelTransform, modelLocation));
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.originalModel.m_5500_(modelGetter, missingTextureErrors);
    }

    public static class BuiltinMixedBakedModel
    extends BakedModelWrapper {
        public BuiltinMixedBakedModel(BakedModel originalModel) {
            super(originalModel);
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean useAmbientOcclusion(BlockState state) {
            return false;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            quads.addAll(super.getQuads(state, side, rand, extraData));
            if (extraData == null || extraData == EmptyModelData.INSTANCE) {
                return quads;
            }
            List quadProviders = (List)extraData.getData(BuiltinMixedModelData.PROP);
            if (quadProviders != null) {
                for (IQuadProvider provider : quadProviders) {
                    List<BakedQuad> additionalQuads = provider.getQuads(state, side, rand);
                    if (additionalQuads == null || additionalQuads.isEmpty()) continue;
                    quads.addAll(additionalQuads);
                }
            }
            return quads;
        }
    }

    public static class Loader
    implements IModelLoader {
        public void m_6213_(ResourceManager resourceManager) {
        }

        public IModelGeometry read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            modelContents.remove("loader");
            UnbakedModel model = (UnbakedModel)deserializationContext.deserialize((JsonElement)modelContents, BlockModel.class);
            return new BuiltinMixedModel(model);
        }
    }
}

