/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.feature_client.model_loaders.block_specific.roof_model_loader.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.block_specific.roof_model_loader.util.RoofBottomBox;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.block_specific.roof_model_loader.util.RoofTileBox;
import net.dark_roleplay.projectbrazier.feature_client.model_loaders.util.AdvancedModelBox;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.Material;

public class RoofModelGenerator {
    List<AdvancedModelBox> fullBoxes = new ArrayList<AdvancedModelBox>();
    List<AdvancedModelBox> leftRim = new ArrayList<AdvancedModelBox>();
    List<AdvancedModelBox> rightRim = new ArrayList<AdvancedModelBox>();
    List<AdvancedModelBox> bottomRim = new ArrayList<AdvancedModelBox>();
    List<AdvancedModelBox> leftBottomRim = new ArrayList<AdvancedModelBox>();
    List<AdvancedModelBox> rightBottomRim = new ArrayList<AdvancedModelBox>();
    Vector3f offset;
    int shingleCount;
    float actualHeight;
    float actualDepth;
    float unrotatedLength;
    double singleLength;
    double singleLengthPlank;
    double angle;
    double angle2;
    double sqrtC;
    int tileOffset;

    public RoofModelGenerator(double depth, double height, int shingleCount, Vector3f offset, int tileOffset, PoseStack matrixStack, Function<Material, TextureAtlasSprite> spriteGetter, Map<String, Material> textures) {
        double sqrC = depth * depth + height * height;
        this.sqrtC = Math.sqrt(sqrC);
        this.singleLengthPlank = this.sqrtC / (double)shingleCount;
        this.angle2 = Math.atan(height / depth);
        this.tileOffset = tileOffset;
        this.offset = offset;
        this.actualDepth = (float)depth;
        this.actualHeight = (float)height;
        this.shingleCount = shingleCount;
        this.unrotatedLength = (float)Math.sqrt(sqrC - (double)(shingleCount * shingleCount));
        this.singleLength = this.unrotatedLength / (float)shingleCount;
        this.angle = Math.atan(height / depth) - Math.atan((double)shingleCount / ((double)shingleCount * this.singleLength));
        TextureAtlasSprite roofTile = spriteGetter.apply(textures.get("roof_shingle"));
        TextureAtlasSprite plank = spriteGetter.apply(textures.get("bottom"));
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122270_((float)this.angle));
        Matrix4f matrix = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85845_(Vector3f.f_122223_.m_122270_((float)this.angle2));
        Matrix4f matrix2 = matrixStack.m_85850_().m_85861_();
        matrixStack.m_85849_();
        this.setupBox(this.fullBoxes, 16.0f, 0.0f, shingleCount, matrix, matrix2, roofTile, plank);
        this.setupBox(this.leftRim, 8.0f, 8.0f, shingleCount, matrix, matrix2, roofTile, plank);
        this.setupBox(this.rightRim, 8.0f, 0.0f, shingleCount, matrix, matrix2, roofTile, plank);
        this.setupBox(this.bottomRim, 16.0f, 0.0f, (int)Math.ceil((float)shingleCount / 2.0f), matrix, matrix2, roofTile, plank);
        this.setupBox(this.leftBottomRim, 8.0f, 8.0f, (int)Math.ceil((float)shingleCount / 2.0f), matrix, matrix2, roofTile, plank);
        this.setupBox(this.rightBottomRim, 8.0f, 0.0f, (int)Math.ceil((float)shingleCount / 2.0f), matrix, matrix2, roofTile, plank);
    }

    public List<BakedQuad> getFull() {
        return this.fullBoxes.stream().map(box -> box.bake()).flatMap(quads -> Arrays.stream(quads)).collect(Collectors.toList());
    }

    public List<BakedQuad> getLeftRim() {
        return this.leftRim.stream().map(box -> box.bake()).flatMap(quads -> Arrays.stream(quads)).collect(Collectors.toList());
    }

    public List<BakedQuad> getRightRim() {
        return this.rightRim.stream().map(box -> box.bake()).flatMap(quads -> Arrays.stream(quads)).collect(Collectors.toList());
    }

    public List<BakedQuad> getBottomRim() {
        return this.bottomRim.stream().map(box -> box.bake()).flatMap(quads -> Arrays.stream(quads)).collect(Collectors.toList());
    }

    public List<BakedQuad> getLeftBottomRim() {
        return this.leftBottomRim.stream().map(box -> box.bake()).flatMap(quads -> Arrays.stream(quads)).collect(Collectors.toList());
    }

    public List<BakedQuad> getRightBottomRim() {
        return this.rightBottomRim.stream().map(box -> box.bake()).flatMap(quads -> Arrays.stream(quads)).collect(Collectors.toList());
    }

    private void setupBox(List<AdvancedModelBox> cubes, float width, float offsetX, int height, Matrix4f matrix, Matrix4f matrix2, TextureAtlasSprite roofTile, TextureAtlasSprite plank) {
        float halfHeight = (float)height / 2.0f - 1.0f;
        float halfLength = this.unrotatedLength / 2.0f;
        Vector3f offset = new Vector3f(8.0f, this.actualHeight / 2.0f, this.actualDepth / 2.0f);
        offset.m_122253_(this.offset);
        for (int i = 0; i < height; ++i) {
            cubes.add(new RoofTileBox(new Vector3f(offsetX - 8.0f, (float)(-i) + halfHeight, (float)((double)i * this.singleLength) - halfLength), new Vector3f(width, 1.0f, (float)this.singleLength), offset, matrix, roofTile, i + this.tileOffset));
        }
        cubes.add(new RoofBottomBox(new Vector3f(offsetX - 8.0f, -1.0f, (float)(-this.sqrtC / 2.0)), new Vector3f(width, 1.0f, (float)this.sqrtC), offset, matrix2, plank));
    }
}

