/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.rendering;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;

public class ModelUtility {
    public static TextureAtlasSprite getBlockSprite(String loc) {
        return ModelUtility.getBlockSprite(new ResourceLocation(loc));
    }

    public static TextureAtlasSprite getBlockSprite(ResourceLocation loc) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(loc);
    }

    public static void generateBakedQuad(BakedQuadBuilder builder, TextureAtlasSprite sprite, Vertex[] vertices) {
        ImmutableList vertexElements = builder.getVertexFormat().m_86023_();
        for (Vertex vertex : vertices) {
            block11: for (int i = 0; i < vertexElements.size(); ++i) {
                VertexFormatElement element = (VertexFormatElement)vertexElements.get(i);
                switch (element.m_86048_()) {
                    case POSITION: {
                        builder.put(i, new float[]{(float)vertex.getPos().m_7096_(), (float)vertex.getPos().m_7098_(), (float)vertex.getPos().m_7094_(), 1.0f});
                        continue block11;
                    }
                    case NORMAL: {
                        builder.put(i, new float[]{(float)vertex.getNormal().m_7096_(), (float)vertex.getNormal().m_7098_(), (float)vertex.getNormal().m_7094_()});
                        continue block11;
                    }
                    case COLOR: {
                        builder.put(i, new float[]{vertex.getColor() >> 16 & 0xFF, vertex.getColor() >> 8 & 0xFF, vertex.getColor() & 0xFF, vertex.getColor() >> 24 & 0xFF});
                        continue block11;
                    }
                    case UV: {
                        switch (element.m_86049_()) {
                            case 0: {
                                builder.put(i, new float[]{sprite.m_118367_((double)vertex.getTexUV().f_82470_), sprite.m_118393_((double)vertex.getTexUV().f_82471_)});
                                continue block11;
                            }
                            case 2: {
                                builder.put(i, new float[]{vertex.getLightUV().f_82470_, vertex.getLightUV().f_82471_});
                                continue block11;
                            }
                        }
                        builder.put(i, new float[0]);
                        continue block11;
                    }
                    default: {
                        builder.put(i, new float[0]);
                    }
                }
            }
        }
    }

    public static class Vertex {
        private Vec3 pos;
        private int color;
        private Vec2 texUV;
        private Vec2 lightUV;
        private Vec3 normal;

        public Vertex(Vec3 pos, int color, Vec2 texUV, Vec2 lightUV, Vec3 normal) {
            this.pos = pos;
            this.color = color;
            this.texUV = texUV;
            this.lightUV = lightUV;
            this.normal = normal;
        }

        public Vec3 getPos() {
            return this.pos;
        }

        public int getColor() {
            return this.color;
        }

        public Vec2 getTexUV() {
            return this.texUV;
        }

        public Vec2 getLightUV() {
            return this.lightUV;
        }

        public Vec3 getNormal() {
            return this.normal;
        }
    }
}

