/*
 * Decompiled with CFR 0.152.
 */
package net.dark_roleplay.projectbrazier.util.rendering;

import com.mojang.datafixers.util.Pair;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class RenderUtils {
    public static Vec3 getCameraPos() {
        return Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
    }

    public static Camera getRenderInfo() {
        return Minecraft.m_91087_().f_91063_.m_109153_();
    }

    public static Matrix4f getProjectionMatrix(float partialTicks) {
        return Minecraft.m_91087_().f_91063_.m_172716_((double)partialTicks);
    }

    public static Matrix4f getViewMatrix() {
        Camera renderInfo = RenderUtils.getRenderInfo();
        Vector3f up = renderInfo.m_90597_();
        Vector3f forward = renderInfo.m_90596_();
        Vector3f right = new Vector3f(-1.0f, 0.0f, 0.0f);
        right.m_122251_(renderInfo.m_90591_());
        return new Matrix4f(new float[]{right.m_122239_(), right.m_122260_(), right.m_122269_(), 0.0f, -up.m_122239_(), -up.m_122260_(), -up.m_122269_(), 0.0f, forward.m_122239_(), forward.m_122260_(), forward.m_122269_(), 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    public static Matrix4f getPVMatrix(float partialTicks) {
        Matrix4f projectionMatrix = RenderUtils.getProjectionMatrix(partialTicks);
        projectionMatrix.m_27644_(RenderUtils.getViewMatrix());
        return projectionMatrix;
    }

    public static Pair<Vec3, Vec3> screenToWorldSpaceRay(float partialTicks) {
        double sWidth = Minecraft.m_91087_().m_91268_().m_85443_();
        double sHeight = Minecraft.m_91087_().m_91268_().m_85444_();
        double mouseX = Minecraft.m_91087_().f_91067_.m_91589_();
        double mouseY = Minecraft.m_91087_().f_91067_.m_91594_();
        Matrix4f pvMatrix = RenderUtils.getPVMatrix(partialTicks);
        pvMatrix.m_27657_();
        Vector4f rayOrigin = new Vector4f((float)((sWidth - mouseX) / sWidth) * 2.0f - 1.0f, (float)((sHeight - mouseY) / sHeight) * 2.0f - 1.0f, -1.0f, 1.0f);
        Vector4f rayEnd = new Vector4f(rayOrigin.m_123601_(), rayOrigin.m_123615_(), 1.0f, 1.0f);
        rayOrigin.m_123607_(pvMatrix);
        if (rayOrigin.m_123617_() == 0.0f) {
            throw new IllegalArgumentException("Received invalid Projection View Matrix, this shouldn't happen!");
        }
        rayOrigin.m_123621_();
        rayEnd.m_123607_(pvMatrix);
        if (rayEnd.m_123617_() == 0.0f) {
            throw new IllegalArgumentException("Received invalid Projection View Matrix, this shouldn't happen!");
        }
        rayEnd.m_123621_();
        Vec3 rayOrigin3 = new Vec3((double)rayOrigin.m_123601_(), (double)rayOrigin.m_123615_(), (double)rayOrigin.m_123616_());
        Vec3 rayEnd3 = new Vec3((double)rayEnd.m_123601_(), (double)rayEnd.m_123615_(), (double)rayEnd.m_123616_());
        Vec3 ray = rayEnd3.m_82546_(rayOrigin3).m_82541_().m_82548_();
        return Pair.of((Object)rayOrigin3, (Object)ray);
    }

    public static Pair<Vec2, Boolean> worldToScreenSpace(Vec3 worldPos, float partialTicks, boolean useScaledGuiSize) {
        Minecraft mc = Minecraft.m_91087_();
        Vec3 cameraPos = RenderUtils.getCameraPos();
        Vector3f newWorldPos = new Vector3f((float)(worldPos.f_82479_ - cameraPos.f_82479_), (float)(worldPos.f_82480_ - cameraPos.f_82480_), (float)(worldPos.f_82481_ - cameraPos.f_82481_));
        Quaternion rotation = RenderUtils.getRenderInfo().m_90591_().m_80161_();
        rotation.m_80157_();
        newWorldPos.m_122251_(rotation);
        if (mc.f_91066_.f_92080_ && RenderUtils.getRenderInfo().m_90592_() instanceof Player) {
            Player playerentity = (Player)RenderUtils.getRenderInfo().m_90592_();
            float f = playerentity.f_19787_ - playerentity.f_19867_;
            float f1 = -(playerentity.f_19787_ + f * partialTicks);
            float f2 = Mth.m_14179_((float)partialTicks, (float)playerentity.f_36099_, (float)playerentity.f_36100_);
            newWorldPos.m_122251_(Vector3f.f_122222_.m_122240_(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f));
            newWorldPos.m_122251_(Vector3f.f_122226_.m_122240_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f));
            newWorldPos.m_122253_(new Vector3f(-Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2), 0.0f));
        }
        float half_height = (float)(useScaledGuiSize ? mc.m_91268_().m_85446_() : mc.m_91268_().m_85444_()) / 2.0f;
        float scale_factor = half_height / (newWorldPos.m_122269_() * (float)Math.tan(Math.toRadians(70.0)));
        int screenWidth = useScaledGuiSize ? mc.m_91268_().m_85445_() : mc.m_91268_().m_85443_();
        int screenHeight = useScaledGuiSize ? mc.m_91268_().m_85446_() : mc.m_91268_().m_85444_();
        return Pair.of((Object)new Vec2(-newWorldPos.m_122239_() * scale_factor + (float)screenWidth / 2.0f, -newWorldPos.m_122260_() * scale_factor + (float)screenHeight / 2.0f), (Object)(newWorldPos.m_122269_() > 0.0f ? 1 : 0));
    }
}

