/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BlackboardBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ServerBoundSetBlackboardPacket {
    private final BlockPos pos;
    private final byte[][] pixels;

    public ServerBoundSetBlackboardPacket(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.pixels = new byte[16][16];
        for (int i = 0; i < this.pixels.length; ++i) {
            this.pixels[i] = buf.m_130052_();
        }
    }

    public ServerBoundSetBlackboardPacket(BlockPos pos, byte[][] pixels) {
        this.pos = pos;
        this.pixels = pixels;
    }

    public static void buffer(ServerBoundSetBlackboardPacket message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        for (int i = 0; i < message.pixels.length; ++i) {
            buf.m_130087_(message.pixels[i]);
        }
    }

    public static void handler(ServerBoundSetBlackboardPacket message, Supplier<NetworkEvent.Context> ctx) {
        Level world = Objects.requireNonNull(ctx.get().getSender()).f_19853_;
        ctx.get().enqueueWork(() -> {
            BlockPos pos = message.pos;
            BlockEntity patt1601$temp = world.m_7702_(pos);
            if (patt1601$temp instanceof BlackboardBlockTile) {
                BlackboardBlockTile board = (BlackboardBlockTile)patt1601$temp;
                world.m_5594_(null, message.pos, SoundEvents.f_12565_, SoundSource.BLOCKS, 1.0f, 0.8f);
                board.setPixels(message.pixels);
                board.m_6596_();
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

