/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.world.generation.structure;

import com.mojang.serialization.Codec;
import java.util.Random;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StructureTempBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;

public class RoadSignFeature
extends Feature<NoneFeatureConfiguration> {
    private final BlockState cobble = Blocks.f_50652_.m_49966_();
    private final BlockState mossyCobble = Blocks.f_50079_.m_49966_();
    private final BlockState fence = Blocks.f_50479_.m_49966_();
    private final BlockState wall = Blocks.f_50274_.m_49966_();
    private final BlockState mossyWall = Blocks.f_50275_.m_49966_();

    public RoadSignFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    private static boolean canGoThrough(LevelAccessor world, BlockPos pos) {
        if (!world.m_6425_(pos).m_76178_()) {
            return false;
        }
        return world.m_7433_(pos, state -> {
            Material material = state.m_60767_();
            return material.m_76336_() || material == Material.f_76274_ || material == Material.f_76300_;
        });
    }

    public static boolean isReplaceable(LevelAccessor world, BlockPos pos) {
        return world.m_7433_(pos, state -> {
            if (state.m_60734_() instanceof StructureTempBlock) {
                return true;
            }
            Material material = state.m_60767_();
            return material.m_76336_() && material != Material.f_76274_;
        });
    }

    public static boolean isNotSolid(LevelAccessor world, BlockPos pos) {
        return !world.m_7433_(pos, state -> state.m_60796_((BlockGetter)world, pos));
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        WorldGenLevel reader = pContext.m_159774_();
        Random rand = pContext.m_159776_();
        BlockPos pos = pContext.m_159777_();
        pos = pos.m_7495_();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                for (int k = 1; k <= 4; ++k) {
                    if ((Math.abs(i) == 2 || Math.abs(j) == 2) && k == 1) continue;
                    reader.m_7731_(pos.m_142082_(i, k, j), ((Block)ModRegistry.STRUCTURE_TEMP.get()).m_49966_(), 2);
                }
            }
        }
        float humidity = ((Biome)reader.m_204166_(pos).m_203334_()).m_47548_();
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                if (Math.abs(i) == 2 && Math.abs(j) == 2) continue;
                reader.m_7731_(pos.m_142082_(i, -1, j), this.cobble, 2);
                BlockPos pathPos = pos.m_142082_(i, 0, j);
                double dist = pos.m_203198_((double)pathPos.m_123341_(), (double)pathPos.m_123342_(), (double)pathPos.m_123343_()) / (double)5.2f;
                if ((double)rand.nextFloat() < dist - 0.15) continue;
                boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
                reader.m_7731_(pathPos, m ? this.mossyCobble : this.cobble, 2);
            }
        }
        boolean m = (double)humidity * 0.75 > (double)rand.nextFloat();
        pos = pos.m_7494_();
        reader.m_7731_(pos, m ? this.mossyWall : this.wall, 2);
        pos = pos.m_7494_();
        reader.m_7731_(pos, this.fence, 2);
        pos = pos.m_7494_();
        reader.m_7731_(pos, this.fence, 2);
        reader.m_7731_(pos.m_7494_(), ((Block)ModRegistry.BLOCK_GENERATOR.get()).m_49966_(), 2);
        return true;
    }
}

