/*
 * Decompiled with CFR 0.152.
 */
package fionathemortal.betterbiomeblend.common;

import fionathemortal.betterbiomeblend.common.Color;
import fionathemortal.betterbiomeblend.common.ColorBlending;
import java.util.concurrent.atomic.AtomicInteger;

public final class BlendChunk {
    public byte[] data;
    public long key;
    public int invalidationCounter;
    public AtomicInteger refCount = new AtomicInteger();
    public long invalidationKey;
    BlendChunk prev;
    BlendChunk next;

    public BlendChunk() {
        this.data = new byte[375];
        this.markAsInvalid();
    }

    public int getReferenceCount() {
        int result = this.refCount.get();
        return result;
    }

    public int release() {
        int result = this.refCount.decrementAndGet();
        return result;
    }

    public void acquire() {
        this.refCount.incrementAndGet();
    }

    public void markAsInvalid() {
        this.key = -1L;
    }

    public int getColor(int x, int y, int z) {
        int blockX = x & 0xF;
        int blockY = y & 0xF;
        int blockZ = z & 0xF;
        int sectionX = blockX >> 2;
        int sectionY = blockY >> 2;
        int sectionZ = blockZ >> 2;
        int offsetX = blockX & 3;
        int offsetY = blockY & 3;
        int offsetZ = blockZ & 3;
        int weight0 = (4 - offsetX) * (4 - offsetZ) * (4 - offsetY);
        int weight1 = offsetX * (4 - offsetZ) * (4 - offsetY);
        int weight2 = (4 - offsetX) * offsetZ * (4 - offsetY);
        int weight3 = offsetX * offsetZ * (4 - offsetY);
        int weight4 = (4 - offsetX) * (4 - offsetZ) * offsetY;
        int weight5 = offsetX * (4 - offsetZ) * offsetY;
        int weight6 = (4 - offsetX) * offsetZ * offsetY;
        int weight7 = offsetX * offsetZ * offsetY;
        int index0 = 3 * ColorBlending.getCacheArrayIndex(5, sectionX, sectionY, sectionZ);
        int index1 = index0 + 3;
        int index2 = index0 + 15;
        int index3 = index0 + 18;
        int index4 = index0 + 75;
        int index5 = index0 + 78;
        int index6 = index0 + 90;
        int index7 = index0 + 93;
        long packed0 = (long)(0xFF & this.data[index0 + 0]) | (long)(0xFF & this.data[index0 + 1]) << 24 | (long)(0xFF & this.data[index0 + 2]) << 48;
        long packed1 = (long)(0xFF & this.data[index1 + 0]) | (long)(0xFF & this.data[index1 + 1]) << 24 | (long)(0xFF & this.data[index1 + 2]) << 48;
        long packed2 = (long)(0xFF & this.data[index2 + 0]) | (long)(0xFF & this.data[index2 + 1]) << 24 | (long)(0xFF & this.data[index2 + 2]) << 48;
        long packed3 = (long)(0xFF & this.data[index3 + 0]) | (long)(0xFF & this.data[index3 + 1]) << 24 | (long)(0xFF & this.data[index3 + 2]) << 48;
        long packed4 = (long)(0xFF & this.data[index4 + 0]) | (long)(0xFF & this.data[index4 + 1]) << 24 | (long)(0xFF & this.data[index4 + 2]) << 48;
        long packed5 = (long)(0xFF & this.data[index5 + 0]) | (long)(0xFF & this.data[index5 + 1]) << 24 | (long)(0xFF & this.data[index5 + 2]) << 48;
        long packed6 = (long)(0xFF & this.data[index6 + 0]) | (long)(0xFF & this.data[index6 + 1]) << 24 | (long)(0xFF & this.data[index6 + 2]) << 48;
        long packed7 = (long)(0xFF & this.data[index7 + 0]) | (long)(0xFF & this.data[index7 + 1]) << 24 | (long)(0xFF & this.data[index7 + 2]) << 48;
        long v0 = packed0 * (long)weight0;
        long v1 = packed1 * (long)weight1;
        long v2 = packed2 * (long)weight2;
        long v3 = packed3 * (long)weight3;
        long v4 = packed4 * (long)weight4;
        long v5 = packed5 * (long)weight5;
        long v6 = packed6 * (long)weight6;
        long v7 = packed7 * (long)weight7;
        long packedResult = (v0 + v1 + v2 + v3 + v4 + v5 + v6 + v7) / 64L;
        int r = (int)packedResult & 0xFF;
        int g = (int)(packedResult >> 24) & 0xFF;
        int b = (int)(packedResult >> 48) & 0xFF;
        int result = Color.makeRGBAWithFullAlpha(r, g, b);
        return result;
    }

    public void removeFromLinkedList() {
        if (this.prev != null) {
            this.prev.next = this.next;
        }
        if (this.next != null) {
            this.next.prev = this.prev;
        }
        this.prev = null;
        this.next = null;
    }
}

