/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllFluids;
import com.simibubi.create.compat.jei.DoubleItemIcon;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.content.contraptions.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.contraptions.processing.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotTooltipCallback;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class CreateRecipeCategory<T extends Recipe<?>>
implements IRecipeCategory<T> {
    public final List<Supplier<List<T>>> recipes = new ArrayList<Supplier<List<T>>>();
    public final List<Supplier<? extends ItemStack>> recipeCatalysts = new ArrayList<Supplier<? extends ItemStack>>();
    protected String name;
    protected RecipeType<T> type;
    private final IDrawable background;
    private final IDrawable icon;
    private static final IDrawable basicSlot = CreateRecipeCategory.asDrawable(AllGuiTextures.JEI_SLOT);
    private static final IDrawable chanceSlot = CreateRecipeCategory.asDrawable(AllGuiTextures.JEI_CHANCE_SLOT);

    public CreateRecipeCategory(IDrawable icon, IDrawable background) {
        this.background = background;
        this.icon = icon;
    }

    public void setCategoryId(String name) {
        this.name = name;
        this.type = RecipeType.create((String)"create", (String)name, this.getRecipeClass());
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public abstract Class<? extends T> getRecipeClass();

    @NotNull
    public RecipeType<T> getRecipeType() {
        return this.type;
    }

    public Component getTitle() {
        return Lang.translateDirect("recipe." + this.name, new Object[0]);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void registerRecipes(IRecipeRegistration registration) {
        this.recipes.forEach(s -> registration.addRecipes(this.getRecipeType(), (List)s.get()));
    }

    public static IDrawable getRenderedSlot() {
        return basicSlot;
    }

    public static IDrawable getRenderedSlot(ProcessingOutput output) {
        return CreateRecipeCategory.getRenderedSlot(output.getChance());
    }

    public static IDrawable getRenderedSlot(float chance) {
        if (chance == 1.0f) {
            return basicSlot;
        }
        return chanceSlot;
    }

    public static IDrawable emptyBackground(int width, int height) {
        return new EmptyBackground(width, height);
    }

    public static IDrawable doubleItemIcon(ItemLike item1, ItemLike item2) {
        return new DoubleItemIcon(() -> new ItemStack(item1), () -> new ItemStack(item2));
    }

    public static IDrawable itemIcon(ItemLike item) {
        return new DoubleItemIcon(() -> new ItemStack(item), () -> ItemStack.f_41583_);
    }

    public static IRecipeSlotTooltipCallback addStochasticTooltip(ProcessingOutput output) {
        return (view, tooltip) -> {
            float chance = output.getChance();
            if (chance != 1.0f) {
                tooltip.add(1, Lang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).m_130940_(ChatFormatting.GOLD));
            }
        };
    }

    public static List<FluidStack> withImprovedVisibility(List<FluidStack> stacks) {
        return stacks.stream().map(CreateRecipeCategory::withImprovedVisibility).collect(Collectors.toList());
    }

    public static FluidStack withImprovedVisibility(FluidStack stack) {
        FluidStack display = stack.copy();
        int displayedAmount = (int)((float)stack.getAmount() * 0.75f) + 250;
        display.setAmount(displayedAmount);
        return display;
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip() {
        return CreateRecipeCategory.addFluidTooltip(-1);
    }

    public static IRecipeSlotTooltipCallback addFluidTooltip(int mbAmount) {
        return (view, tooltip) -> {
            Optional displayed = view.getDisplayedIngredient(VanillaTypes.FLUID);
            if (displayed.isEmpty()) {
                return;
            }
            FluidStack fluidStack = (FluidStack)displayed.get();
            if (fluidStack.getFluid().m_6212_((Fluid)AllFluids.POTION.get())) {
                Component name = fluidStack.getDisplayName();
                if (tooltip.isEmpty()) {
                    tooltip.add(0, name);
                } else {
                    tooltip.set(0, name);
                }
                ArrayList<Component> potionTooltip = new ArrayList<Component>();
                PotionFluidHandler.addPotionTooltip(fluidStack, potionTooltip, 1.0f);
                tooltip.addAll(1, potionTooltip.stream().toList());
            }
            int amount = mbAmount == -1 ? fluidStack.getAmount() : mbAmount;
            MutableComponent text = new TextComponent(String.valueOf(amount)).m_7220_((Component)Lang.translateDirect("generic.unit.millibuckets", new Object[0])).m_130940_(ChatFormatting.GOLD);
            if (tooltip.isEmpty()) {
                tooltip.add(0, text);
            } else {
                List siblings = ((Component)tooltip.get(0)).m_7360_();
                siblings.add(new TextComponent(" "));
                siblings.add(text);
            }
        };
    }

    private static IDrawable asDrawable(final AllGuiTextures texture) {
        return new IDrawable(){

            public int getWidth() {
                return texture.width;
            }

            public int getHeight() {
                return texture.height;
            }

            public void draw(PoseStack poseStack, int xOffset, int yOffset) {
                texture.render(poseStack, xOffset, yOffset);
            }
        };
    }
}

