/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.actors;

import com.simibubi.create.content.contraptions.components.actors.BlockBreakingKineticTileEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BlockBreakingMovementBehaviour
implements MovementBehaviour {
    @Override
    public void startMoving(MovementContext context) {
        if (context.world.f_46443_) {
            return;
        }
        context.data.m_128405_("BreakerId", -BlockBreakingKineticTileEntity.NEXT_BREAKER_ID.incrementAndGet());
    }

    @Override
    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level world = context.world;
        BlockState stateVisited = world.m_8055_(pos);
        if (!stateVisited.m_60796_((BlockGetter)world, pos)) {
            this.damageEntities(context, pos, world);
        }
        if (world.f_46443_) {
            return;
        }
        if (!this.canBreak(world, pos, stateVisited)) {
            return;
        }
        context.data.m_128365_("BreakingPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        context.stall = true;
    }

    public void damageEntities(MovementContext context, BlockPos pos, Level world) {
        DamageSource damageSource;
        Object object = context.contraption.entity;
        if (object instanceof OrientedContraptionEntity) {
            OrientedContraptionEntity oce = (OrientedContraptionEntity)((Object)object);
            if (oce.nonDamageTicks > 0) {
                return;
            }
        }
        if ((damageSource = this.getDamageSource()) == null && !this.throwsEntities()) {
            return;
        }
        block0: for (Entity entity : world.m_45976_(Entity.class, new AABB(pos))) {
            if (entity instanceof ItemEntity || entity instanceof AbstractContraptionEntity) continue;
            if (entity instanceof AbstractMinecart) {
                for (Entity passenger : entity.m_146897_()) {
                    if (!(passenger instanceof AbstractContraptionEntity) || ((AbstractContraptionEntity)passenger).getContraption() != context.contraption) continue;
                    continue block0;
                }
            }
            if (damageSource != null && !world.f_46443_) {
                float damage = (float)Mth.m_14008_((double)(6.0 * Math.pow(context.relativeMotion.m_82553_(), 0.4) + 1.0), (double)2.0, (double)10.0);
                entity.m_6469_(damageSource, damage);
            }
            if (!this.throwsEntities() || world.f_46443_ != entity instanceof Player) continue;
            this.throwEntity(context, entity);
        }
    }

    protected void throwEntity(MovementContext context, Entity entity) {
        Vec3 motionBoost = context.motion.m_82520_(0.0, context.motion.m_82553_() / 4.0, 0.0);
        int maxBoost = 4;
        if (motionBoost.m_82553_() > (double)maxBoost) {
            motionBoost = motionBoost.m_82546_(motionBoost.m_82541_().m_82490_(motionBoost.m_82553_() - (double)maxBoost));
        }
        entity.m_20256_(entity.m_20184_().m_82549_(motionBoost));
        entity.f_19864_ = true;
    }

    protected DamageSource getDamageSource() {
        return null;
    }

    protected boolean throwsEntities() {
        return this.getDamageSource() != null;
    }

    @Override
    public void cancelStall(MovementContext context) {
        CompoundTag data = context.data;
        if (context.world.f_46443_) {
            return;
        }
        if (!data.m_128441_("BreakingPos")) {
            return;
        }
        Level world = context.world;
        int id = data.m_128451_("BreakerId");
        BlockPos breakingPos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("BreakingPos"));
        data.m_128473_("Progress");
        data.m_128473_("TicksUntilNextProgress");
        data.m_128473_("BreakingPos");
        MovementBehaviour.super.cancelStall(context);
        world.m_6801_(id, breakingPos, -1);
    }

    @Override
    public void stopMoving(MovementContext context) {
        this.cancelStall(context);
    }

    @Override
    public void tick(MovementContext context) {
        this.tickBreaker(context);
        CompoundTag data = context.data;
        if (!data.m_128441_("WaitingTicks")) {
            return;
        }
        int waitingTicks = data.m_128451_("WaitingTicks");
        if (waitingTicks-- > 0) {
            data.m_128405_("WaitingTicks", waitingTicks);
            context.stall = true;
            return;
        }
        BlockPos pos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("LastPos"));
        data.m_128473_("WaitingTicks");
        data.m_128473_("LastPos");
        context.stall = false;
        this.visitNewPosition(context, pos);
    }

    public void tickBreaker(MovementContext context) {
        CompoundTag data = context.data;
        if (context.world.f_46443_) {
            return;
        }
        if (!data.m_128441_("BreakingPos")) {
            context.stall = false;
            return;
        }
        if (context.relativeMotion.equals((Object)Vec3.f_82478_)) {
            context.stall = false;
            return;
        }
        int ticksUntilNextProgress = data.m_128451_("TicksUntilNextProgress");
        if (ticksUntilNextProgress-- > 0) {
            data.m_128405_("TicksUntilNextProgress", ticksUntilNextProgress);
            return;
        }
        Level world = context.world;
        BlockPos breakingPos = NbtUtils.m_129239_((CompoundTag)data.m_128469_("BreakingPos"));
        int destroyProgress = data.m_128451_("Progress");
        int id = data.m_128451_("BreakerId");
        BlockState stateToBreak = world.m_8055_(breakingPos);
        float blockHardness = stateToBreak.m_60800_((BlockGetter)world, breakingPos);
        if (!this.canBreak(world, breakingPos, stateToBreak)) {
            if (destroyProgress != 0) {
                destroyProgress = 0;
                data.m_128473_("Progress");
                data.m_128473_("TicksUntilNextProgress");
                data.m_128473_("BreakingPos");
                world.m_6801_(id, breakingPos, -1);
            }
            context.stall = false;
            return;
        }
        float breakSpeed = Mth.m_14036_((float)(Math.abs(context.getAnimationSpeed()) / 500.0f), (float)0.0078125f, (float)16.0f);
        destroyProgress += Mth.m_14045_((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - destroyProgress));
        world.m_5594_(null, breakingPos, stateToBreak.m_60827_().m_56778_(), SoundSource.NEUTRAL, 0.25f, 1.0f);
        if (destroyProgress >= 10) {
            world.m_6801_(id, breakingPos, -1);
            BlockPos ogPos = breakingPos;
            BlockState stateAbove = world.m_8055_(breakingPos.m_7494_());
            while (stateAbove.m_60734_() instanceof FallingBlock) {
                breakingPos = breakingPos.m_7494_();
                stateAbove = world.m_8055_(breakingPos.m_7494_());
            }
            stateToBreak = world.m_8055_(breakingPos);
            context.stall = false;
            if (this.shouldDestroyStartBlock(stateToBreak)) {
                BlockHelper.destroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (ItemStack)stack));
            }
            this.onBlockBroken(context, ogPos, stateToBreak);
            ticksUntilNextProgress = -1;
            data.m_128473_("Progress");
            data.m_128473_("TicksUntilNextProgress");
            data.m_128473_("BreakingPos");
            return;
        }
        ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        world.m_6801_(id, breakingPos, destroyProgress);
        data.m_128405_("TicksUntilNextProgress", ticksUntilNextProgress);
        data.m_128405_("Progress", destroyProgress);
    }

    protected boolean shouldDestroyStartBlock(BlockState stateToBreak) {
        return true;
    }

    public boolean canBreak(Level world, BlockPos breakingPos, BlockState state) {
        float blockHardness = state.m_60800_((BlockGetter)world, breakingPos);
        return BlockBreakingKineticTileEntity.isBreakable(state, blockHardness);
    }

    protected void onBlockBroken(MovementContext context, BlockPos pos, BlockState brokenState) {
        if (!(brokenState.m_60734_() instanceof FallingBlock)) {
            return;
        }
        CompoundTag data = context.data;
        data.m_128405_("WaitingTicks", 10);
        data.m_128365_("LastPos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
        context.stall = true;
    }
}

