/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.fluids.actors;

import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.fluids.actors.FluidDrainingBehaviour;
import com.simibubi.create.content.contraptions.fluids.actors.FluidFillingBehaviour;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyBlock;
import com.simibubi.create.content.contraptions.fluids.actors.HosePulleyFluidHandler;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class HosePulleyTileEntity
extends KineticTileEntity {
    LerpedFloat offset = LerpedFloat.linear().startWithValue(0.0);
    boolean isMoving = true;
    private SmartFluidTank internalTank = new SmartFluidTank(1500, this::onTankContentsChanged);
    private LazyOptional<IFluidHandler> capability;
    private FluidDrainingBehaviour drainer;
    private FluidFillingBehaviour filler;
    private HosePulleyFluidHandler handler = new HosePulleyFluidHandler(this.internalTank, this.filler, this.drainer, () -> this.f_58858_.m_6625_((int)Math.ceil(this.offset.getValue())), () -> !this.isMoving);
    private boolean infinite;

    public HosePulleyTileEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        this.capability = LazyOptional.of(() -> this.handler);
    }

    @Override
    public void sendData() {
        this.infinite = this.filler.infinite || this.drainer.infinite;
        super.sendData();
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        boolean addToGoggleTooltip = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.infinite) {
            TooltipHelper.addHint(tooltip, "hint.hose_pulley", new Object[0]);
        }
        return addToGoggleTooltip;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
        this.drainer = new FluidDrainingBehaviour(this);
        this.filler = new FluidFillingBehaviour(this);
        behaviours.add(this.drainer);
        behaviours.add(this.filler);
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.HOSE_PULLEY, AllAdvancements.HOSE_PULLEY_LAVA);
    }

    protected void onTankContentsChanged(FluidStack contents) {
    }

    @Override
    public void onSpeedChanged(float previousSpeed) {
        this.isMoving = true;
        if (this.getSpeed() == 0.0f) {
            this.offset.forceNextSync();
            this.offset.setValue(Math.round(this.offset.getValue()));
            this.isMoving = false;
        }
        if (this.isMoving) {
            float newOffset = this.offset.getValue() + this.getMovementSpeed();
            if (newOffset < 0.0f) {
                this.isMoving = false;
            }
            if (!this.f_58857_.m_8055_(this.f_58858_.m_6625_((int)Math.ceil(newOffset))).m_60767_().m_76336_()) {
                this.isMoving = false;
            }
            if (this.isMoving) {
                this.drainer.reset();
                this.filler.reset();
            }
        }
        super.onSpeedChanged(previousSpeed);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82363_(0.0, (double)(-this.offset.getValue()), 0.0);
    }

    @Override
    public void tick() {
        super.tick();
        float newOffset = this.offset.getValue() + this.getMovementSpeed();
        if (newOffset < 0.0f) {
            newOffset = 0.0f;
            this.isMoving = false;
        }
        if (!this.f_58857_.m_8055_(this.f_58858_.m_6625_((int)Math.ceil(newOffset))).m_60767_().m_76336_()) {
            newOffset = (int)newOffset;
            this.isMoving = false;
        }
        if (this.getSpeed() == 0.0f) {
            this.isMoving = false;
        }
        this.offset.setValue(newOffset);
        this.invalidateRenderBoundingBox();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.isMoving) {
            return;
        }
        int ceil = (int)Math.ceil(this.offset.getValue() + this.getMovementSpeed());
        if (this.getMovementSpeed() > 0.0f && this.f_58857_.m_8055_(this.f_58858_.m_6625_(ceil)).m_60767_().m_76336_()) {
            this.isMoving = true;
            this.drainer.reset();
            this.filler.reset();
            return;
        }
        this.sendData();
    }

    @Override
    protected void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128365_("Offset", (Tag)this.offset.writeNBT());
        compound.m_128365_("Tank", (Tag)this.internalTank.writeToNBT(new CompoundTag()));
        super.write(compound, clientPacket);
        if (clientPacket) {
            compound.m_128379_("Infinite", this.infinite);
        }
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.offset.readNBT(compound.m_128469_("Offset"), clientPacket);
        this.internalTank.readFromNBT(compound.m_128469_("Tank"));
        super.read(compound, clientPacket);
        if (clientPacket) {
            this.infinite = compound.m_128471_("Infinite");
        }
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.capability.invalidate();
    }

    public float getMovementSpeed() {
        float movementSpeed = HosePulleyTileEntity.convertToLinear(this.getSpeed());
        if (this.f_58857_.f_46443_) {
            movementSpeed *= ServerSpeedProvider.get();
        }
        return movementSpeed;
    }

    public float getInterpolatedOffset(float pt) {
        return this.offset.getValue(pt);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isFluidHandlerCap(cap) && (side == null || HosePulleyBlock.hasPipeTowards((LevelReader)this.f_58857_, this.f_58858_, this.m_58900_(), side))) {
            return this.capability.cast();
        }
        return super.getCapability(cap, side);
    }
}

