/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.relays.advanced;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.AllTileEntities;
import com.simibubi.create.content.contraptions.base.HorizontalAxisKineticBlock;
import com.simibubi.create.content.contraptions.relays.advanced.SpeedControllerTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.CogWheelBlock;
import com.simibubi.create.content.contraptions.relays.elementary.ICogWheel;
import com.simibubi.create.foundation.block.ITE;
import com.simibubi.create.foundation.utility.placement.IPlacementHelper;
import com.simibubi.create.foundation.utility.placement.PlacementHelpers;
import com.simibubi.create.foundation.utility.placement.PlacementOffset;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SpeedControllerBlock
extends HorizontalAxisKineticBlock
implements ITE<SpeedControllerTileEntity> {
    private static final int placementHelperId = PlacementHelpers.register(new PlacementHelper());

    public SpeedControllerBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState above = context.m_43725_().m_8055_(context.m_8083_().m_7494_());
        if (ICogWheel.isLargeCog(above) && ((Direction.Axis)above.m_61143_((Property)CogWheelBlock.AXIS)).m_122479_()) {
            return (BlockState)this.m_49966_().m_61124_(HORIZONTAL_AXIS, (Comparable)(above.m_61143_((Property)CogWheelBlock.AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X));
        }
        return super.m_5573_(context);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block p_220069_4_, BlockPos neighbourPos, boolean p_220069_6_) {
        if (neighbourPos.equals((Object)pos.m_7494_())) {
            this.withTileEntityDo((BlockGetter)world, pos, SpeedControllerTileEntity::updateBracket);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        ItemStack heldItem = player.m_21120_(hand);
        IPlacementHelper helper = PlacementHelpers.get(placementHelperId);
        if (helper.matchesItem(heldItem)) {
            return helper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.m_41720_(), player, hand, ray);
        }
        return InteractionResult.PASS;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.SPEED_CONTROLLER;
    }

    @Override
    public Class<SpeedControllerTileEntity> getTileEntityClass() {
        return SpeedControllerTileEntity.class;
    }

    @Override
    public BlockEntityType<? extends SpeedControllerTileEntity> getTileEntityType() {
        return (BlockEntityType)AllTileEntities.ROTATION_SPEED_CONTROLLER.get();
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        @Override
        public Predicate<ItemStack> getItemPredicate() {
            return ((Predicate<ItemStack>)ICogWheel::isLargeCogItem).and(ICogWheel::isDedicatedCogItem);
        }

        @Override
        public Predicate<BlockState> getStatePredicate() {
            return AllBlocks.ROTATION_SPEED_CONTROLLER::has;
        }

        @Override
        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            Direction.Axis newAxis;
            BlockPos newPos = pos.m_7494_();
            if (!world.m_8055_(newPos).m_60767_().m_76336_()) {
                return PlacementOffset.fail();
            }
            Direction.Axis axis = newAxis = state.m_61143_(HorizontalAxisKineticBlock.HORIZONTAL_AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
            if (!CogWheelBlock.isValidCogwheelPosition(true, (LevelReader)world, newPos, newAxis)) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)newPos, s -> (BlockState)s.m_61124_((Property)CogWheelBlock.AXIS, (Comparable)newAxis));
        }
    }
}

