/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.placement;

import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class PlacementResult {
    private static final Vector4f ZERO = new Vector4f(Vector3f.f_176763_);
    private final boolean success;
    private final Vector4f color;
    private final Component failureMessage;

    public static PlacementResult success() {
        return PlacementResult.success(IClientConfiguration::getSuccessfulPlacementColor);
    }

    public static PlacementResult success(Function<IClientConfiguration, Supplier<Vector4f>> clientColor) {
        return new PlacementResult(true, clientColor, TextComponent.f_131282_);
    }

    public static PlacementResult failure(Function<IClientConfiguration, Supplier<Vector4f>> clientColor) {
        return PlacementResult.failure(clientColor, TextComponent.f_131282_);
    }

    public static PlacementResult failure(Function<IClientConfiguration, Supplier<Vector4f>> clientColor, Component message) {
        return new PlacementResult(false, clientColor, message);
    }

    public static PlacementResult success(Vector4f color) {
        return new PlacementResult(true, color, TextComponent.f_131282_);
    }

    public static PlacementResult failure(Vector4f color) {
        return PlacementResult.failure(color, TextComponent.f_131282_);
    }

    public static PlacementResult failure(Vector4f color, Component message) {
        return new PlacementResult(false, color, message);
    }

    private PlacementResult(boolean success, Function<IClientConfiguration, Supplier<Vector4f>> clientColor, Component failureMessage) {
        this(success, (Vector4f)DistExecutor.unsafeRunForDist(() -> (Supplier)clientColor.apply(IClientConfiguration.getInstance()), () -> () -> ZERO), failureMessage);
    }

    private PlacementResult(boolean success, Vector4f color, Component failureMessage) {
        this.success = success;
        this.color = color;
        this.failureMessage = failureMessage;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Vector4f getColor() {
        return this.color;
    }

    public Component getFailureMessage() {
        return this.failureMessage;
    }
}

