/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.platforms.common.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.client.Localization;
import shetiphian.core.common.IColored;
import shetiphian.platforms.Values;
import shetiphian.platforms.client.render.RenderRegistry;
import shetiphian.platforms.common.misc.EnumPlatformType;
import shetiphian.platforms.common.misc.EnumSubType;

public class ItemBlockPlatform
extends BlockItem
implements IColored {
    private final EnumPlatformType platformType;

    public ItemBlockPlatform(EnumPlatformType platformType, Block block, Item.Properties properties) {
        super(block, properties);
        this.platformType = platformType;
        this.doLater();
    }

    public void doLater() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> RenderRegistry.COLORIZE.add((Object)this));
    }

    public EnumPlatformType getPlatformType() {
        return this.platformType;
    }

    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> list) {
        if (this.m_41389_(group)) {
            list.add((Object)ItemBlockPlatform.createStack(this.m_40614_(), new ItemStack((ItemLike)Blocks.f_50705_), new ItemStack((ItemLike)Blocks.f_50705_)));
        }
    }

    public void m_7836_(ItemStack stack, Level world, Player player) {
        CompoundTag texture;
        ItemStack textureStack;
        CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
        if (!tag.m_128441_(ItemBlockPlatform.getFrameTextureKey())) {
            textureStack = new ItemStack((ItemLike)Blocks.f_50705_);
            texture = new CompoundTag();
            textureStack.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getFrameTextureKey(), (Tag)texture);
        }
        if (!tag.m_128441_(ItemBlockPlatform.getCoverTextureKey())) {
            textureStack = new ItemStack((ItemLike)Blocks.f_50705_);
            texture = new CompoundTag();
            textureStack.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getCoverTextureKey(), (Tag)texture);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag advancedTooltips) {
        if (!stack.m_41619_()) {
            if (advancedTooltips.m_7050_() || Screen.m_96638_()) {
                CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
                this.addTextureInfo(tooltip, tag, ItemBlockPlatform.getFrameTextureKey());
                this.addTextureInfo(tooltip, tag, ItemBlockPlatform.getCoverTextureKey());
            } else {
                tooltip.add((Component)new TextComponent(Localization.get((String)"info.shetiphian.holdshift")));
            }
        }
    }

    private void addTextureInfo(List<Component> tooltip, CompoundTag tag, String key) {
        if (tag.m_128441_(key)) {
            ItemStack tagStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_(key));
            if (!tagStack.m_41619_()) {
                tooltip.add((Component)new TextComponent(" * " + Localization.get((String)tagStack.m_41778_())));
            } else {
                tagStack = new ItemStack((ItemLike)Blocks.f_50705_);
                tooltip.add((Component)new TextComponent(" * /!\\ " + Localization.get((String)"info.shetiphian.texture.invalid") + " /!\\"));
                tooltip.add((Component)new TextComponent(" ** " + Localization.get((String)tagStack.m_41778_())));
                tooltip.add((Component)new TextComponent(" ** " + Localization.get((String)"info.shetiphian.texture.defaulted") + Localization.get((String)tagStack.m_41778_())));
            }
        } else {
            ItemStack tagStack = new ItemStack((ItemLike)Blocks.f_50705_);
            tooltip.add((Component)new TextComponent(" * /!\\ " + Localization.get((String)"info.shetiphian.texture.missing") + " /!\\"));
            tooltip.add((Component)new TextComponent(" ** " + Localization.get((String)"info.shetiphian.texture.defaulted") + Localization.get((String)tagStack.m_41778_())));
        }
    }

    public static ItemStack createStack(EnumPlatformType platformType, ItemStack texFrame, ItemStack texCover) {
        return ItemBlockPlatform.createStack(Values.blocksPlatform.get((Object)platformType), texFrame, texCover);
    }

    public static ItemStack createStack(Block block, ItemStack texFrame, ItemStack texCover) {
        ItemStack stack;
        if (block != null && !(stack = new ItemStack((ItemLike)block)).m_41619_()) {
            CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
            if (texFrame.m_41619_()) {
                texFrame = new ItemStack((ItemLike)Blocks.f_50705_);
            }
            CompoundTag texture = new CompoundTag();
            texFrame.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getFrameTextureKey(), (Tag)texture);
            if (texCover.m_41619_()) {
                texCover = new ItemStack((ItemLike)Blocks.f_50705_);
            }
            texture = new CompoundTag();
            texCover.m_41739_(texture);
            tag.m_128365_(ItemBlockPlatform.getCoverTextureKey(), (Tag)texture);
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getFrameTextureStack(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = ItemBlockPlatform.getNBTTag(stack)).m_128441_(ItemBlockPlatform.getFrameTextureKey())) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_(ItemBlockPlatform.getFrameTextureKey()));
        }
        return new ItemStack((ItemLike)Blocks.f_50705_);
    }

    public static ItemStack getCoverTextureStack(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && (tag = ItemBlockPlatform.getNBTTag(stack)).m_128441_(ItemBlockPlatform.getCoverTextureKey())) {
            return ItemStack.m_41712_((CompoundTag)tag.m_128469_(ItemBlockPlatform.getCoverTextureKey()));
        }
        return new ItemStack((ItemLike)Blocks.f_50705_);
    }

    public static void setSubType(ItemStack stack, EnumSubType subtype) {
        if (!stack.m_41619_()) {
            CompoundTag tag = ItemBlockPlatform.getNBTTag(stack);
            tag.m_128359_("subtype", subtype.m_7912_());
        }
    }

    public static EnumSubType getSubType(ItemStack stack) {
        CompoundTag tag;
        if (!stack.m_41619_() && stack.m_41720_() instanceof ItemBlockPlatform && (tag = ItemBlockPlatform.getNBTTag(stack)).m_128441_("subtype")) {
            return EnumSubType.byName(tag.m_128461_("subtype"));
        }
        return EnumSubType.NONE;
    }

    public static String getFrameTextureKey() {
        return "frame_texture_item";
    }

    public static String getCoverTextureKey() {
        return "cover_texture_item";
    }

    public static CompoundTag getNBTTag(ItemStack stack) {
        return stack.m_41698_("BlockEntityTag");
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        if (index >= 1 && index <= 4) {
            return Minecraft.m_91087_().getItemColors().m_92676_(index == 1 || index == 3 ? ItemBlockPlatform.getFrameTextureStack(data.stack) : ItemBlockPlatform.getCoverTextureStack(data.stack), 0);
        }
        return 0xFFFFFF;
    }
}

