/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.TaskUtils;
import mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import mca.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FishingTask
extends AbstractChoreTask {
    private BlockPos targetWater;
    private boolean hasCastRod;
    private int ticks;
    private List<ItemStack> list;

    public FishingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.FISH;
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager) && villager.m_21223_() == villager.m_21233_();
    }

    @Override
    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof FishingRodItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.fishing.norod");
            } else {
                villager.m_21008_(InteractionHand.MAIN_HAND, villager.m_141944_().m_8020_(i));
            }
        }
        LootTable loottable = world.m_142572_().m_129898_().m_79217_(BuiltInLootTables.f_78720_);
        LootContext.Builder lootcontext$builder = new LootContext.Builder(world).m_78972_(LootContextParams.f_81460_, (Object)villager.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)Items.f_42523_)).m_78972_(LootContextParams.f_81455_, (Object)villager).m_78977_(this.villager.m_21187_()).m_78963_(0.0f);
        this.list = loottable.m_79129_(lootcontext$builder.m_78975_(LootContextParamSets.f_81414_));
    }

    @Override
    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.keepRunning(world, villager, time);
        if (!InventoryUtils.contains((Container)villager.m_141944_(), FishingRodItem.class) && !villager.m_21033_(EquipmentSlot.MAINHAND)) {
            this.abandonJobWithMessage("chore.fishing.norod");
        } else if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof FishingRodItem);
            ItemStack stack2 = villager.m_141944_().m_8020_(i);
            villager.m_21008_(InteractionHand.MAIN_HAND, stack2);
        }
        if (this.targetWater == null) {
            List<BlockPos> nearbyStaticLiquid = TaskUtils.getNearbyBlocks(villager.m_142538_(), villager.f_19853_, blockState -> blockState.m_60713_(Blocks.f_49990_), 12, 3);
            this.targetWater = nearbyStaticLiquid.stream().filter(p -> villager.f_19853_.m_8055_(p).m_60734_() == Blocks.f_49990_).min(Comparator.comparingDouble(d -> villager.m_20275_(d.m_123341_(), d.m_123342_(), d.m_123343_()))).orElse(null);
        } else if (villager.m_20275_(this.targetWater.m_123341_(), this.targetWater.m_123342_(), this.targetWater.m_123343_()) < 5.0) {
            villager.m_21573_().m_26573_();
            villager.lookAt(this.targetWater);
            if (!this.hasCastRod) {
                villager.m_6674_(InteractionHand.MAIN_HAND);
                this.hasCastRod = true;
            }
            ++this.ticks;
            if (this.ticks >= villager.f_19853_.f_46441_.nextInt(200) + 200) {
                if (villager.f_19853_.f_46441_.nextFloat() >= 0.35f) {
                    ItemStack stack3 = this.list.get(villager.m_21187_().nextInt(this.list.size())).m_41777_();
                    villager.m_6674_(InteractionHand.MAIN_HAND);
                    villager.m_141944_().m_19173_(stack3);
                    villager.m_21205_().m_41622_(1, (LivingEntity)villager, player -> player.m_21166_(EquipmentSlot.MAINHAND));
                }
                this.ticks = 0;
            }
        } else {
            villager.moveTowards(this.targetWater);
        }
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.m_21120_(InteractionHand.MAIN_HAND);
        if (!stack.m_41619_()) {
            villager.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        villager.m_6674_(InteractionHand.MAIN_HAND);
    }
}

