/*
 * Decompiled with CFR 0.152.
 */
package mca.item;

import dev.architectury.core.item.ArchitecturySpawnEggItem;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import mca.MCA;
import mca.TagsMCA;
import mca.block.BlocksMCA;
import mca.client.book.Book;
import mca.client.book.pages.DynamicListPage;
import mca.client.book.pages.ScribbleTextPage;
import mca.client.book.pages.TitlePage;
import mca.crafting.recipe.RecipesMCA;
import mca.entity.EntitiesMCA;
import mca.entity.ai.relationship.Gender;
import mca.item.BabyItem;
import mca.item.BlueprintItem;
import mca.item.ExtendedWrittenBookItem;
import mca.item.FamilyTreeItem;
import mca.item.ItemGroupMCA;
import mca.item.MatchmakersRingItem;
import mca.item.ScytheItem;
import mca.item.StaffOfLifeItem;
import mca.item.TooltippedItem;
import mca.item.VillagerEditorItem;
import mca.item.WeddingRingItem;
import mca.item.WhistleItem;
import mca.resources.Supporters;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public interface ItemsMCA {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"mca", (ResourceKey)Registry.f_122904_);
    public static final RegistrySupplier<Item> MALE_VILLAGER_SPAWN_EGG = ItemsMCA.register("male_villager_spawn_egg", () -> new ArchitecturySpawnEggItem(EntitiesMCA.MALE_VILLAGER, 6200063, 3368636, ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> FEMALE_VILLAGER_SPAWN_EGG = ItemsMCA.register("female_villager_spawn_egg", () -> new ArchitecturySpawnEggItem(EntitiesMCA.FEMALE_VILLAGER, 15228065, 14890636, ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> MALE_ZOMBIE_VILLAGER_SPAWN_EGG = ItemsMCA.register("male_zombie_villager_spawn_egg", () -> new ArchitecturySpawnEggItem(EntitiesMCA.MALE_ZOMBIE_VILLAGER, 6208255, 3385020, ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> FEMALE_ZOMBIE_VILLAGER_SPAWN_EGG = ItemsMCA.register("female_zombie_villager_spawn_egg", () -> new ArchitecturySpawnEggItem(EntitiesMCA.FEMALE_ZOMBIE_VILLAGER, 15248545, 14919308, ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> GRIM_REAPER_SPAWN_EGG = ItemsMCA.register("grim_reaper_spawn_egg", () -> new ArchitecturySpawnEggItem(EntitiesMCA.GRIM_REAPER, 3151125, 2759732, ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> BABY_BOY = ItemsMCA.register("baby_boy", () -> new BabyItem(Gender.MALE, ItemsMCA.baseProps().m_41487_(1)));
    public static final RegistrySupplier<Item> BABY_GIRL = ItemsMCA.register("baby_girl", () -> new BabyItem(Gender.FEMALE, ItemsMCA.baseProps().m_41487_(1)));
    public static final RegistrySupplier<Item> WEDDING_RING = ItemsMCA.register("wedding_ring", () -> new WeddingRingItem(ItemsMCA.unstackableProps()));
    public static final RegistrySupplier<Item> WEDDING_RING_RG = ItemsMCA.register("wedding_ring_rg", () -> new WeddingRingItem(ItemsMCA.unstackableProps()));
    public static final RegistrySupplier<Item> ENGAGEMENT_RING = ItemsMCA.register("engagement_ring", () -> new WeddingRingItem(ItemsMCA.unstackableProps(), 0.5f));
    public static final RegistrySupplier<Item> ENGAGEMENT_RING_RG = ItemsMCA.register("engagement_ring_rg", () -> new WeddingRingItem(ItemsMCA.unstackableProps(), 0.5f));
    public static final RegistrySupplier<Item> MATCHMAKERS_RING = ItemsMCA.register("matchmakers_ring", () -> new MatchmakersRingItem(ItemsMCA.baseProps().m_41487_(2)));
    public static final RegistrySupplier<Item> VILLAGER_EDITOR = ItemsMCA.register("villager_editor", () -> new VillagerEditorItem(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> STAFF_OF_LIFE = ItemsMCA.register("staff_of_life", () -> new StaffOfLifeItem(ItemsMCA.baseProps().m_41503_(5)));
    public static final RegistrySupplier<Item> WHISTLE = ItemsMCA.register("whistle", () -> new WhistleItem(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> BLUEPRINT = ItemsMCA.register("blueprint", () -> new BlueprintItem(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> FAMILY_TREE = ItemsMCA.register("family_tree", () -> new FamilyTreeItem(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> BOOK_DEATH = ItemsMCA.register("book_death", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("death").setBackground(MCA.locate("textures/gui/books/death.png")).setTextFormatting(ChatFormatting.WHITE).addPage(new TitlePage("death", ChatFormatting.GRAY)).addSimplePages(3, 0).addPage(new ScribbleTextPage(MCA.locate("textures/gui/scribbles/test.png"), "death", 3)).addSimplePages(9, 4)));
    public static final RegistrySupplier<Item> BOOK_ROMANCE = ItemsMCA.register("book_romance", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("romance").setBackground(MCA.locate("textures/gui/books/romance.png")).addPage(new TitlePage("romance")).addSimplePages(10)));
    public static final RegistrySupplier<Item> BOOK_FAMILY = ItemsMCA.register("book_family", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("family").addPage(new TitlePage("family")).addSimplePages(8)));
    public static final RegistrySupplier<Item> BOOK_ROSE_GOLD = ItemsMCA.register("book_rose_gold", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("rose_gold").setBackground(MCA.locate("textures/gui/books/rose_gold.png")).addPage(new TitlePage("rose_gold")).addSimplePages(5)));
    public static final RegistrySupplier<Item> BOOK_INFECTION = ItemsMCA.register("book_infection", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("infection").setBackground(MCA.locate("textures/gui/books/infection.png")).addPage(new TitlePage("infection")).addSimplePages(6)));
    public static final RegistrySupplier<Item> BOOK_BLUEPRINT = ItemsMCA.register("book_blueprint", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("blueprint").setBackground(MCA.locate("textures/gui/books/blueprint.png")).setTextFormatting(ChatFormatting.WHITE).addPage(new TitlePage("blueprint", ChatFormatting.WHITE)).addSimplePages(6)));
    public static final RegistrySupplier<Item> BOOK_SUPPORTERS = ItemsMCA.register("book_supporters", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps(), new Book("supporters").setBackground(MCA.locate("textures/gui/books/supporters.png")).addPage(new TitlePage("supporters")).addPage(new DynamicListPage("mca.books.supporters.patrons", page -> Supporters.getSupporterGroup("mca:patrons").stream().map(s -> new TextComponent(s).m_130940_(ChatFormatting.RED)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.wiki", page -> Supporters.getSupporterGroup("mca:wiki").stream().map(s -> new TextComponent(s).m_130940_(ChatFormatting.GOLD)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.contributors", page -> Supporters.getSupporterGroup("mca:contributors").stream().map(s -> new TextComponent(s).m_130940_(ChatFormatting.DARK_GREEN)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.translators", page -> Supporters.getSupporterGroup("mca:translators").stream().map(s -> new TextComponent(s).m_130940_(ChatFormatting.DARK_BLUE)).collect(Collectors.toList()))).addPage(new DynamicListPage("mca.books.supporters.old", page -> Supporters.getSupporterGroup("mca:old").stream().map(s -> new TextComponent(s).m_130940_(ChatFormatting.BLACK)).collect(Collectors.toList()))).addPage(new TitlePage("mca.books.supporters.thanks", ""))));
    public static final RegistrySupplier<Item> LETTER = ItemsMCA.register("letter", () -> new ExtendedWrittenBookItem(ItemsMCA.baseProps().m_41487_(1), new Book("letter", null).setBackground(MCA.locate("textures/gui/books/paper.png"))));
    public static final RegistrySupplier<Item> GOLD_DUST = ItemsMCA.register("gold_dust", () -> new Item(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> ROSE_GOLD_DUST = ItemsMCA.register("rose_gold_dust", () -> new Item(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> ROSE_GOLD_INGOT = ItemsMCA.register("rose_gold_ingot", () -> new Item(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> DIVORCE_PAPERS = ItemsMCA.register("divorce_papers", () -> new TooltippedItem(ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> ROSE_GOLD_BLOCK = ItemsMCA.register("rose_gold_block", () -> new BlockItem((Block)BlocksMCA.ROSE_GOLD_BLOCK.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> ROSE_GOLD_ORE = ItemsMCA.register("rose_gold_ore", () -> new BlockItem((Block)BlocksMCA.ROSE_GOLD_ORE.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> JEWELER_WORKBENCH = ItemsMCA.register("jeweler_workbench", () -> new BlockItem((Block)BlocksMCA.JEWELER_WORKBENCH.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> GRAVELLING_HEADSTONE = ItemsMCA.register("gravelling_headstone", () -> new BlockItem((Block)BlocksMCA.GRAVELLING_HEADSTONE.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> UPRIGHT_HEADSTONE = ItemsMCA.register("upright_headstone", () -> new BlockItem((Block)BlocksMCA.UPRIGHT_HEADSTONE.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> SLANTED_HEADSTONE = ItemsMCA.register("slanted_headstone", () -> new BlockItem((Block)BlocksMCA.SLANTED_HEADSTONE.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> CROSS_HEADSTONE = ItemsMCA.register("cross_headstone", () -> new BlockItem((Block)BlocksMCA.CROSS_HEADSTONE.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> WALL_HEADSTONE = ItemsMCA.register("wall_headstone", () -> new BlockItem((Block)BlocksMCA.WALL_HEADSTONE.get(), ItemsMCA.baseProps()));
    public static final RegistrySupplier<Item> SCYTHE = ItemsMCA.register("scythe", () -> new ScytheItem(ItemsMCA.baseProps()));

    public static void bootstrap() {
        ITEMS.register();
        TagsMCA.Blocks.bootstrap();
        RecipesMCA.bootstrap();
    }

    public static RegistrySupplier<Item> register(String name, Supplier<Item> item) {
        return ITEMS.register(new ResourceLocation("mca", name), item);
    }

    public static Item.Properties baseProps() {
        return new Item.Properties().m_41491_(ItemGroupMCA.MCA_GROUP);
    }

    public static Item.Properties unstackableProps() {
        return ItemsMCA.baseProps().m_41487_(1);
    }
}

