/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public enum GlNumericType {
    FLOAT(4, "float", 5126),
    UBYTE(1, "ubyte", 5121),
    BYTE(1, "byte", 5120),
    USHORT(2, "ushort", 5123),
    SHORT(2, "short", 5122),
    UINT(4, "uint", 5125),
    INT(4, "int", 5124);

    private static final GlNumericType[] VALUES;
    private static final Map<String, GlNumericType> NAME_LOOKUP;
    private final int byteWidth;
    private final String typeName;
    private final int glEnum;

    private GlNumericType(int bytes, String name, int glEnum) {
        this.byteWidth = bytes;
        this.typeName = name;
        this.glEnum = glEnum;
    }

    public int getByteWidth() {
        return this.byteWidth;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getGlEnum() {
        return this.glEnum;
    }

    public void castAndBuffer(ByteBuffer buf, int val) {
        if (this == UBYTE || this == BYTE) {
            buf.put((byte)val);
        } else if (this == USHORT || this == SHORT) {
            buf.putShort((short)val);
        } else if (this == UINT || this == INT) {
            buf.putInt(val);
        }
    }

    @Nullable
    public static GlNumericType byName(String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
    }

    public String toString() {
        return this.typeName;
    }

    static {
        VALUES = GlNumericType.values();
        NAME_LOOKUP = Arrays.stream(VALUES).collect(Collectors.toMap(GlNumericType::getTypeName, type -> type));
    }
}

