/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server.modules;

import atomicstryker.dynamiclights.server.DynamicLights;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemConfigHelper;
import atomicstryker.dynamiclights.server.ItemLightLevels;
import atomicstryker.dynamiclights.server.modules.LightConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DroppedItemsLightSource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ItemConfigHelper itemsMap;
    private static ItemConfigHelper notWaterProofItems;
    private static final HashMap<ItemEntity, EntityItemAdapter> trackedItemMap;
    private LightConfig config;

    public DroppedItemsLightSource() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void serverStartEvent(ServerAboutToStartEvent event) {
        LightConfig defaultConfig = new LightConfig();
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.f_50081_), 14));
        defaultConfig.getItemsList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.f_50141_), 15));
        defaultConfig.getNotWaterProofList().add(ItemConfigHelper.fromItemStack(new ItemStack((ItemLike)Blocks.f_50081_), 0));
        MinecraftServer server = event.getServer();
        File configFile = new File(server.m_129971_(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights_droppeditems.cfg");
        try {
            this.config = GsonConfig.loadConfigWithDefault(LightConfig.class, configFile, defaultConfig);
            if (this.config == null) {
                throw new UnsupportedOperationException("DroppedItemsLightSource failed parsing config file somehow...");
            }
            itemsMap = new ItemConfigHelper(this.config.getItemsList(), LOGGER);
            notWaterProofItems = new ItemConfigHelper(this.config.getNotWaterProofList(), LOGGER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void entityJoinsWorld(EntityJoinWorldEvent event) {
        ItemEntity itemEntity;
        int lightLevel;
        if (event.getWorld().m_5776_()) {
            return;
        }
        if (event.getEntity() instanceof ItemEntity && (lightLevel = this.getLightFromItemStack((itemEntity = (ItemEntity)event.getEntity()).m_32055_())) > 0) {
            EntityItemAdapter entityItemAdapter = new EntityItemAdapter(itemEntity);
            trackedItemMap.put(itemEntity, entityItemAdapter);
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        Iterator<Map.Entry<ItemEntity, EntityItemAdapter>> iterator = trackedItemMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ItemEntity, EntityItemAdapter> mapEntry = iterator.next();
            if (mapEntry.getKey().m_6084_()) {
                mapEntry.getValue().onTick();
                continue;
            }
            iterator.remove();
        }
    }

    private int getLightFromItemStack(ItemStack stack) {
        int level = ItemLightLevels.getLightFromItemStack(stack, "dropped");
        if (level > 0 && level <= 15) {
            return level;
        }
        return itemsMap.getLightLevel(stack);
    }

    static {
        trackedItemMap = new HashMap();
    }

    private class EntityItemAdapter
    implements IDynamicLightSource {
        private ItemEntity entity;
        private int lightLevel = 0;
        private boolean enabled = false;
        private boolean notWaterProof;

        public EntityItemAdapter(ItemEntity eI) {
            this.entity = eI;
            this.notWaterProof = notWaterProofItems.getLightLevel(eI.m_32055_()) > 0 || eI.m_32055_().m_204131_().anyMatch(rl -> rl.f_203868_().equals((Object)DynamicLights.NOT_WATERPROOF_TAG));
        }

        public void onTick() {
            if (this.entity.m_6060_()) {
                this.lightLevel = 15;
            } else {
                this.lightLevel = DroppedItemsLightSource.this.getLightFromItemStack(this.entity.m_32055_());
                if (this.notWaterProof && this.entity.m_20069_()) {
                    this.lightLevel = 0;
                }
            }
            if (!this.enabled && this.lightLevel > 0) {
                this.enableLight();
            } else if (this.enabled && this.lightLevel < 1) {
                this.disableLight();
            }
        }

        private void enableLight() {
            DynamicLights.addLightSource(this);
            this.enabled = true;
        }

        private void disableLight() {
            DynamicLights.removeLightSource(this);
            this.enabled = false;
        }

        @Override
        public Entity getAttachmentEntity() {
            return this.entity;
        }

        @Override
        public int getLightLevel() {
            return this.notWaterProof && this.entity.m_20069_() ? 0 : this.lightLevel;
        }
    }
}

