/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.transport;

import com.simibubi.create.content.kinetics.belt.BeltBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.content.kinetics.belt.BeltSlope;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.BeltCrusherInteractionHandler;
import com.simibubi.create.content.kinetics.belt.transport.BeltFunnelInteractionHandler;
import com.simibubi.create.content.kinetics.belt.transport.BeltTunnelInteractionHandler;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.ServerSpeedProvider;
import io.github.fabricators_of_create.porting_lib.util.ItemStackUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class BeltInventory {
    final BeltBlockEntity belt;
    private List<TransportedItemStack> items;
    List<TransportedItemStack> toInsert;
    List<TransportedItemStack> toRemove;
    boolean beltMovementPositive;
    final float SEGMENT_WINDOW = 0.75f;
    public final ToInsertSnapshotParticipant toInsertSnapshotParticipant = new ToInsertSnapshotParticipant();
    public final ItemsSnapshotParticipant itemsSnapshotParticipant = new ItemsSnapshotParticipant();

    public BeltInventory(BeltBlockEntity be) {
        this.belt = be;
        this.items = new LinkedList<TransportedItemStack>();
        this.toInsert = new LinkedList<TransportedItemStack>();
        this.toRemove = new LinkedList<TransportedItemStack>();
    }

    public void tick() {
        if (!this.toInsert.isEmpty() || !this.toRemove.isEmpty()) {
            this.toInsert.forEach(this::insert);
            this.toInsert.clear();
            this.items.removeAll(this.toRemove);
            this.toRemove.clear();
            this.belt.method_5431();
            this.belt.sendData();
        }
        if (this.belt.getSpeed() == 0.0f) {
            return;
        }
        if (this.beltMovementPositive != this.belt.getDirectionAwareBeltMovementSpeed() > 0.0f) {
            this.beltMovementPositive = !this.beltMovementPositive;
            Collections.reverse(this.items);
            this.belt.method_5431();
            this.belt.sendData();
        }
        TransportedItemStack stackInFront = null;
        TransportedItemStack currentItem = null;
        Iterator<TransportedItemStack> iterator = this.items.iterator();
        float beltSpeed = this.belt.getDirectionAwareBeltMovementSpeed();
        class_2350 movementFacing = this.belt.getMovementFacing();
        boolean horizontal = this.belt.method_11010().method_11654(BeltBlock.SLOPE) == BeltSlope.HORIZONTAL;
        float spacing = 1.0f;
        class_1937 world = this.belt.method_10997();
        boolean onClient = world.field_9236 && !this.belt.isVirtual();
        Ending ending = Ending.UNRESOLVED;
        while (iterator.hasNext()) {
            float diffToEnd;
            stackInFront = currentItem;
            currentItem = iterator.next();
            currentItem.prevBeltPosition = currentItem.beltPosition;
            currentItem.prevSideOffset = currentItem.sideOffset;
            if (currentItem.stack.method_7960()) {
                iterator.remove();
                currentItem = null;
                continue;
            }
            float movement = beltSpeed;
            if (onClient) {
                movement *= ServerSpeedProvider.get();
            }
            if (world.field_9236 && currentItem.locked) continue;
            if (currentItem.lockedExternally) {
                currentItem.lockedExternally = false;
                continue;
            }
            boolean noMovement = false;
            float currentPos = currentItem.beltPosition;
            if (stackInFront != null) {
                float diff = stackInFront.beltPosition - currentPos;
                if (Math.abs(diff) <= spacing) {
                    noMovement = true;
                }
                movement = this.beltMovementPositive ? Math.min(movement, diff - spacing) : Math.max(movement, diff + spacing);
            }
            float f = diffToEnd = this.beltMovementPositive ? (float)this.belt.beltLength - currentPos : -currentPos;
            if (Math.abs(diffToEnd) < Math.abs(movement) + 1.0f) {
                if (ending == Ending.UNRESOLVED) {
                    ending = this.resolveEnding();
                }
                diffToEnd += this.beltMovementPositive ? -ending.margin : ending.margin;
            }
            float limitedMovement = this.beltMovementPositive ? Math.min(movement, diffToEnd) : Math.max(movement, diffToEnd);
            float nextOffset = currentItem.beltPosition + limitedMovement;
            if (!onClient && horizontal) {
                class_1799 item = currentItem.stack;
                if (this.handleBeltProcessingAndCheckIfRemoved(currentItem, nextOffset, noMovement)) {
                    iterator.remove();
                    this.belt.sendData();
                    continue;
                }
                if (item != currentItem.stack) {
                    this.belt.sendData();
                }
                if (currentItem.locked) continue;
            }
            if (BeltFunnelInteractionHandler.checkForFunnels(this, currentItem, nextOffset)) continue;
            if (currentItem.stack.method_7960()) {
                iterator.remove();
                continue;
            }
            if (noMovement || BeltTunnelInteractionHandler.flapTunnelsAndCheckIfStuck(this, currentItem, nextOffset) || BeltCrusherInteractionHandler.checkForCrushers(this, currentItem, nextOffset)) continue;
            currentItem.beltPosition += limitedMovement;
            currentItem.sideOffset += (currentItem.getTargetSideOffset() - currentItem.sideOffset) * Math.abs(limitedMovement) * 2.0f;
            currentPos = currentItem.beltPosition;
            if (limitedMovement == movement || onClient) continue;
            int lastOffset = this.beltMovementPositive ? this.belt.beltLength - 1 : 0;
            class_2338 nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1);
            if (ending == Ending.FUNNEL) continue;
            if (ending == Ending.INSERT) {
                class_1799 remainder;
                DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((class_1922)world, nextPosition, DirectBeltInputBehaviour.TYPE);
                if (inputBehaviour == null || !inputBehaviour.canInsertFromSide(movementFacing) || ItemStackUtil.equals((class_1799)(remainder = inputBehaviour.handleInsertion(currentItem, movementFacing, false)), (class_1799)currentItem.stack, (boolean)false)) continue;
                currentItem.stack = remainder;
                if (remainder.method_7960()) {
                    iterator.remove();
                }
                BeltTunnelInteractionHandler.flapTunnel(this, lastOffset, movementFacing, false);
                this.belt.sendData();
                continue;
            }
            if (ending == Ending.BLOCKED || ending != Ending.EJECT) continue;
            this.eject(currentItem);
            iterator.remove();
            BeltTunnelInteractionHandler.flapTunnel(this, lastOffset, movementFacing, false);
            this.belt.sendData();
        }
    }

    protected boolean handleBeltProcessingAndCheckIfRemoved(TransportedItemStack currentItem, float nextOffset, boolean noMovement) {
        int currentSegment = (int)currentItem.beltPosition;
        if (currentItem.locked) {
            BeltProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(currentSegment);
            TransportedItemStackHandlerBehaviour stackHandlerBehaviour = this.getTransportedItemStackHandlerAtSegment(currentSegment);
            if (stackHandlerBehaviour == null) {
                return false;
            }
            if (processingBehaviour == null) {
                currentItem.locked = false;
                this.belt.sendData();
                return false;
            }
            BeltProcessingBehaviour.ProcessingResult result = processingBehaviour.handleHeldItem(currentItem, stackHandlerBehaviour);
            if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
                return true;
            }
            if (result == BeltProcessingBehaviour.ProcessingResult.HOLD) {
                return false;
            }
            currentItem.locked = false;
            this.belt.sendData();
            return false;
        }
        if (noMovement) {
            return false;
        }
        if (currentItem.beltPosition > 0.5f || this.beltMovementPositive) {
            int firstUpcomingSegment = (int)(currentItem.beltPosition + (this.beltMovementPositive ? 0.5f : -0.5f));
            int step = this.beltMovementPositive ? 1 : -1;
            int segment = firstUpcomingSegment;
            while (this.beltMovementPositive ? (float)segment + 0.5f <= nextOffset : (float)segment + 0.5f >= nextOffset) {
                BeltProcessingBehaviour processingBehaviour = this.getBeltProcessingAtSegment(segment);
                TransportedItemStackHandlerBehaviour stackHandlerBehaviour = this.getTransportedItemStackHandlerAtSegment(segment);
                if (processingBehaviour != null && stackHandlerBehaviour != null && !BeltProcessingBehaviour.isBlocked((class_1922)this.belt.method_10997(), BeltHelper.getPositionForOffset(this.belt, segment))) {
                    BeltProcessingBehaviour.ProcessingResult result = processingBehaviour.handleReceivedItem(currentItem, stackHandlerBehaviour);
                    if (result == BeltProcessingBehaviour.ProcessingResult.REMOVE) {
                        return true;
                    }
                    if (result == BeltProcessingBehaviour.ProcessingResult.HOLD) {
                        currentItem.beltPosition = (float)segment + 0.5f + (this.beltMovementPositive ? 0.001953125f : -0.001953125f);
                        currentItem.locked = true;
                        this.belt.sendData();
                        return false;
                    }
                }
                segment += step;
            }
        }
        return false;
    }

    protected BeltProcessingBehaviour getBeltProcessingAtSegment(int segment) {
        return BlockEntityBehaviour.get((class_1922)this.belt.method_10997(), BeltHelper.getPositionForOffset(this.belt, segment).method_10086(2), BeltProcessingBehaviour.TYPE);
    }

    protected TransportedItemStackHandlerBehaviour getTransportedItemStackHandlerAtSegment(int segment) {
        return BlockEntityBehaviour.get((class_1922)this.belt.method_10997(), BeltHelper.getPositionForOffset(this.belt, segment), TransportedItemStackHandlerBehaviour.TYPE);
    }

    private Ending resolveEnding() {
        class_2338 nextPosition;
        class_1937 world = this.belt.method_10997();
        DirectBeltInputBehaviour inputBehaviour = BlockEntityBehaviour.get((class_1922)world, nextPosition = BeltHelper.getPositionForOffset(this.belt, this.beltMovementPositive ? this.belt.beltLength : -1), DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour != null) {
            return Ending.INSERT;
        }
        if (BlockHelper.hasBlockSolidSide(world.method_8320(nextPosition), (class_1922)world, nextPosition, this.belt.getMovementFacing().method_10153())) {
            return Ending.BLOCKED;
        }
        return Ending.EJECT;
    }

    public boolean canInsertAt(int segment) {
        return this.canInsertAtFromSide(segment, class_2350.field_11036);
    }

    public boolean canInsertAtFromSide(int segment, class_2350 side) {
        float segmentPos = segment;
        if (this.belt.getMovementFacing() == side.method_10153()) {
            return false;
        }
        if (this.belt.getMovementFacing() != side) {
            segmentPos += 0.5f;
        } else if (!this.beltMovementPositive) {
            segmentPos += 1.0f;
        }
        for (TransportedItemStack stack : this.items) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        for (TransportedItemStack stack : this.toInsert) {
            if (!this.isBlocking(segment, side, segmentPos, stack)) continue;
            return false;
        }
        return true;
    }

    private boolean isBlocking(int segment, class_2350 side, float segmentPos, TransportedItemStack stack) {
        float currentPos = stack.beltPosition;
        return stack.insertedAt == segment && stack.insertedFrom == side && (this.beltMovementPositive ? currentPos <= segmentPos + 1.0f : currentPos >= segmentPos - 1.0f);
    }

    public void addItem(TransportedItemStack newStack) {
        this.toInsert.add(newStack);
    }

    private void insert(TransportedItemStack newStack) {
        if (newStack.stack.method_7960()) {
            return;
        }
        if (this.items.isEmpty()) {
            this.items.add(newStack);
        } else {
            int index = 0;
            for (TransportedItemStack stack : this.items) {
                if (stack.compareTo(newStack) > 0 == this.beltMovementPositive) break;
                ++index;
            }
            this.items.add(index, newStack);
        }
    }

    public TransportedItemStack getStackAtOffset(int offset) {
        float min = offset;
        float max = offset + 1;
        for (TransportedItemStack stack : this.items) {
            if (stack.beltPosition > max || !(stack.beltPosition > min)) continue;
            return stack;
        }
        return null;
    }

    public void read(class_2487 nbt) {
        this.items.clear();
        nbt.method_10554("Items", 10).forEach(inbt -> this.items.add(TransportedItemStack.read((class_2487)inbt)));
        this.beltMovementPositive = nbt.method_10577("PositiveOrder");
    }

    public class_2487 write() {
        class_2487 nbt = new class_2487();
        class_2499 itemsNBT = new class_2499();
        this.items.forEach(stack -> itemsNBT.add((Object)stack.serializeNBT()));
        nbt.method_10566("Items", (class_2520)itemsNBT);
        nbt.method_10556("PositiveOrder", this.beltMovementPositive);
        return nbt;
    }

    public void eject(TransportedItemStack stack) {
        class_1799 ejected = stack.stack;
        class_243 outPos = BeltHelper.getVectorForOffset(this.belt, stack.beltPosition);
        float movementSpeed = Math.max(Math.abs(this.belt.getBeltMovementSpeed()), 0.125f);
        class_243 outMotion = class_243.method_24954((class_2382)this.belt.getBeltChainDirection()).method_1021((double)movementSpeed).method_1031(0.0, 0.125, 0.0);
        outPos = outPos.method_1019(outMotion.method_1029().method_1021(0.001));
        class_1542 entity = new class_1542(this.belt.method_10997(), outPos.field_1352, outPos.field_1351 + 0.375, outPos.field_1350, ejected);
        entity.method_18799(outMotion);
        entity.method_6988();
        entity.field_6037 = true;
        this.belt.method_10997().method_8649((class_1297)entity);
    }

    public void ejectAll() {
        this.items.forEach(this::eject);
        this.items.clear();
    }

    public void applyToEachWithin(float position, float maxDistanceToPosition, Function<TransportedItemStack, TransportedItemStackHandlerBehaviour.TransportedResult> processFunction) {
        boolean dirty = false;
        for (TransportedItemStack transported : this.items) {
            TransportedItemStackHandlerBehaviour.TransportedResult result;
            if (this.toRemove.contains(transported)) continue;
            class_1799 stackBefore = transported.stack.method_7972();
            if (Math.abs(position - transported.beltPosition) >= maxDistanceToPosition || (result = processFunction.apply(transported)) == null || result.didntChangeFrom(stackBefore)) continue;
            dirty = true;
            if (result.hasHeldOutput()) {
                TransportedItemStack held = result.getHeldOutput();
                held.beltPosition = (float)((int)position) + 0.5f - (this.beltMovementPositive ? 0.001953125f : -0.001953125f);
                this.toInsert.add(held);
            }
            this.toInsert.addAll(result.getOutputs());
            this.toRemove.add(transported);
        }
        if (dirty) {
            this.belt.method_5431();
            this.belt.sendData();
        }
    }

    public List<TransportedItemStack> getTransportedItems() {
        return this.items;
    }

    public class ToInsertSnapshotParticipant
    extends SnapshotParticipant<List<TransportedItemStack>> {
        protected List<TransportedItemStack> createSnapshot() {
            LinkedList<TransportedItemStack> snapshot = new LinkedList<TransportedItemStack>();
            BeltInventory.this.toInsert.forEach(stack -> snapshot.add(stack.fullCopy()));
            return snapshot;
        }

        protected void readSnapshot(List<TransportedItemStack> snapshot) {
            BeltInventory.this.toInsert = snapshot;
        }

        protected void onFinalCommit() {
            BeltInventory.this.belt.method_5431();
            BeltInventory.this.belt.sendData();
        }
    }

    public class ItemsSnapshotParticipant
    extends SnapshotParticipant<List<TransportedItemStack>> {
        protected List<TransportedItemStack> createSnapshot() {
            LinkedList<TransportedItemStack> snapshot = new LinkedList<TransportedItemStack>();
            BeltInventory.this.items.forEach(stack -> snapshot.add(stack.fullCopy()));
            return snapshot;
        }

        protected void readSnapshot(List<TransportedItemStack> snapshot) {
            BeltInventory.this.items = snapshot;
        }

        protected void onFinalCommit() {
            BeltInventory.this.belt.method_5431();
            BeltInventory.this.belt.sendData();
        }
    }

    private static enum Ending {
        UNRESOLVED(0.0f),
        EJECT(0.0f),
        INSERT(0.25f),
        FUNNEL(0.5f),
        BLOCKED(0.45f);

        private float margin;

        private Ending(float f) {
            this.margin = f;
        }
    }
}

