/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.mechanicalArm;

import com.jozufozu.flywheel.backend.instancing.InstancedRenderDispatcher;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.ITransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.AllArmInteractionPointTypes;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmAngleTarget;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlock;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import com.simibubi.create.infrastructure.config.AllConfigs;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import io.github.fabricators_of_create.porting_lib.util.EnvExecutor;
import io.github.fabricators_of_create.porting_lib.util.ItemStackUtil;
import io.github.fabricators_of_create.porting_lib.util.NBTSerializer;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2387;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2802;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4076;

public class ArmBlockEntity
extends KineticBlockEntity
implements ITransformableBlockEntity {
    List<ArmInteractionPoint> inputs = new ArrayList<ArmInteractionPoint>();
    List<ArmInteractionPoint> outputs = new ArrayList<ArmInteractionPoint>();
    class_2499 interactionPointTag = null;
    float chasedPointProgress;
    int chasedPointIndex;
    class_1799 heldItem = class_1799.field_8037;
    Phase phase = Phase.SEARCH_INPUTS;
    boolean goggles;
    ArmAngleTarget previousTarget = ArmAngleTarget.NO_TARGET;
    LerpedFloat lowerArmAngle;
    LerpedFloat upperArmAngle;
    LerpedFloat baseAngle = LerpedFloat.angular();
    LerpedFloat headAngle;
    LerpedFloat clawAngle;
    float previousBaseAngle;
    boolean updateInteractionPoints;
    int tooltipWarmup;
    protected ScrollOptionBehaviour<SelectionMode> selectionMode;
    protected int lastInputIndex = -1;
    protected int lastOutputIndex = -1;
    protected boolean redstoneLocked;

    public ArmBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
        this.baseAngle.startWithValue(this.previousTarget.baseAngle);
        this.lowerArmAngle = LerpedFloat.angular();
        this.lowerArmAngle.startWithValue(this.previousTarget.lowerArmAngle);
        this.upperArmAngle = LerpedFloat.angular();
        this.upperArmAngle.startWithValue(this.previousTarget.upperArmAngle);
        this.headAngle = LerpedFloat.angular();
        this.headAngle.startWithValue(this.previousTarget.headAngle);
        this.clawAngle = LerpedFloat.angular();
        this.previousBaseAngle = this.previousTarget.baseAngle;
        this.updateInteractionPoints = true;
        this.redstoneLocked = false;
        this.tooltipWarmup = 15;
        this.goggles = false;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.selectionMode = new ScrollOptionBehaviour<SelectionMode>(SelectionMode.class, (class_2561)Lang.translateDirect("logistics.when_multiple_outputs_available", new Object[0]), this, new SelectionModeValueBox());
        behaviours.add(this.selectionMode);
        this.registerAwardables(behaviours, AllAdvancements.ARM_BLAZE_BURNER, AllAdvancements.ARM_MANY_TARGETS, AllAdvancements.MECHANICAL_ARM, AllAdvancements.MUSICAL_ARM);
    }

    @Override
    public void tick() {
        super.tick();
        this.initInteractionPoints();
        boolean targetReached = this.tickMovementProgress();
        if (this.tooltipWarmup > 0) {
            --this.tooltipWarmup;
        }
        if (this.chasedPointProgress < 1.0f) {
            ArmInteractionPoint point;
            if (this.phase == Phase.MOVE_TO_INPUT && (point = this.getTargetedInteractionPoint()) != null) {
                point.keepAlive();
            }
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.phase == Phase.MOVE_TO_INPUT) {
            this.collectItem();
        } else if (this.phase == Phase.MOVE_TO_OUTPUT) {
            this.depositItem();
        } else if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.searchForItem();
        }
        if (targetReached) {
            this.lazyTick();
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.chasedPointProgress < 0.5f) {
            return;
        }
        if (this.phase == Phase.SEARCH_INPUTS || this.phase == Phase.DANCING) {
            this.checkForMusic();
        }
        if (this.phase == Phase.SEARCH_OUTPUTS) {
            this.searchForDestination();
        }
    }

    private void checkForMusic() {
        boolean hasMusic = this.checkForMusicAmong(this.inputs) || this.checkForMusicAmong(this.outputs);
        if (hasMusic != (this.phase == Phase.DANCING)) {
            this.phase = hasMusic ? Phase.DANCING : Phase.SEARCH_INPUTS;
            this.method_5431();
            this.sendData();
        }
    }

    @Override
    protected class_238 createRenderBoundingBox() {
        return super.createRenderBoundingBox().method_1014(3.0);
    }

    private boolean checkForMusicAmong(List<ArmInteractionPoint> list) {
        for (ArmInteractionPoint armInteractionPoint : list) {
            class_2680 state;
            if (!(armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint) || !(state = this.field_11863.method_8320(armInteractionPoint.getPos())).method_28500((class_2769)class_2387.field_11180).orElse(false).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private boolean tickMovementProgress() {
        boolean targetReachedPreviously = this.chasedPointProgress >= 1.0f;
        this.chasedPointProgress += Math.min(256.0f, Math.abs(this.getSpeed())) / 1024.0f;
        if (this.chasedPointProgress > 1.0f) {
            this.chasedPointProgress = 1.0f;
        }
        if (!this.field_11863.field_9236) {
            return !targetReachedPreviously && this.chasedPointProgress >= 1.0f;
        }
        ArmInteractionPoint targetedInteractionPoint = this.getTargetedInteractionPoint();
        ArmAngleTarget previousTarget = this.previousTarget;
        ArmAngleTarget target = targetedInteractionPoint == null ? ArmAngleTarget.NO_TARGET : targetedInteractionPoint.getTargetAngles(this.field_11867, this.isOnCeiling());
        this.baseAngle.setValue(AngleHelper.angleLerp(this.chasedPointProgress, this.previousBaseAngle, target == ArmAngleTarget.NO_TARGET ? (double)this.previousBaseAngle : (double)target.baseAngle));
        if (this.chasedPointProgress < 0.5f) {
            target = ArmAngleTarget.NO_TARGET;
        } else {
            previousTarget = ArmAngleTarget.NO_TARGET;
        }
        float progress = this.chasedPointProgress == 1.0f ? 1.0f : this.chasedPointProgress % 0.5f * 2.0f;
        this.lowerArmAngle.setValue(class_3532.method_16439((float)progress, (float)previousTarget.lowerArmAngle, (float)target.lowerArmAngle));
        this.upperArmAngle.setValue(class_3532.method_16439((float)progress, (float)previousTarget.upperArmAngle, (float)target.upperArmAngle));
        this.headAngle.setValue(AngleHelper.angleLerp(progress, previousTarget.headAngle % 360.0f, target.headAngle % 360.0f));
        return false;
    }

    protected boolean isOnCeiling() {
        class_2680 state = this.method_11010();
        return this.method_11002() && state.method_28500((class_2769)ArmBlock.CEILING).orElse(false) != false;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (!this.heldItem.method_7960()) {
            class_2248.method_9577((class_1937)this.field_11863, (class_2338)this.field_11867, (class_1799)this.heldItem);
        }
    }

    @Nullable
    private ArmInteractionPoint getTargetedInteractionPoint() {
        if (this.chasedPointIndex == -1) {
            return null;
        }
        if (this.phase == Phase.MOVE_TO_INPUT && this.chasedPointIndex < this.inputs.size()) {
            return this.inputs.get(this.chasedPointIndex);
        }
        if (this.phase == Phase.MOVE_TO_OUTPUT && this.chasedPointIndex < this.outputs.size()) {
            return this.outputs.get(this.chasedPointIndex);
        }
        return null;
    }

    protected void searchForItem() {
        int scanRange;
        if (this.redstoneLocked) {
            return;
        }
        boolean foundInput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastInputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastInputIndex + 2 : this.inputs.size();
        if (scanRange > this.inputs.size()) {
            scanRange = this.inputs.size();
        }
        for (int i = startIndex; i < scanRange; ++i) {
            ArmInteractionPoint armInteractionPoint = this.inputs.get(i);
            if (!armInteractionPoint.isValid() || this.getDistributableAmount(armInteractionPoint) == 0) continue;
            this.selectIndex(true, i);
            foundInput = true;
            break;
        }
        if (!foundInput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastInputIndex = -1;
        }
        if (this.lastInputIndex == this.inputs.size() - 1) {
            this.lastInputIndex = -1;
        }
    }

    protected void searchForDestination() {
        int scanRange;
        class_1799 held = this.heldItem.method_7972();
        boolean foundOutput = false;
        int startIndex = this.selectionMode.get() == SelectionMode.PREFER_FIRST ? 0 : this.lastOutputIndex + 1;
        int n = scanRange = this.selectionMode.get() == SelectionMode.FORCED_ROUND_ROBIN ? this.lastOutputIndex + 2 : this.outputs.size();
        if (scanRange > this.outputs.size()) {
            scanRange = this.outputs.size();
        }
        try (Transaction t = TransferUtil.getTransaction();){
            for (int i = startIndex; i < scanRange; ++i) {
                class_1799 remainder;
                ArmInteractionPoint armInteractionPoint = this.outputs.get(i);
                if (!armInteractionPoint.isValid() || ItemStackUtil.equals((class_1799)(remainder = armInteractionPoint.insert(held, (TransactionContext)t)), (class_1799)this.heldItem, (boolean)false)) continue;
                this.selectIndex(false, i);
                foundOutput = true;
                break;
            }
        }
        if (!foundOutput && this.selectionMode.get() == SelectionMode.ROUND_ROBIN) {
            this.lastOutputIndex = -1;
        }
        if (this.lastOutputIndex == this.outputs.size() - 1) {
            this.lastOutputIndex = -1;
        }
    }

    private void selectIndex(boolean input, int index) {
        this.phase = input ? Phase.MOVE_TO_INPUT : Phase.MOVE_TO_OUTPUT;
        this.chasedPointIndex = index;
        this.chasedPointProgress = 0.0f;
        if (input) {
            this.lastInputIndex = index;
        } else {
            this.lastOutputIndex = index;
        }
        this.sendData();
        this.method_5431();
    }

    protected int getDistributableAmount(ArmInteractionPoint armInteractionPoint) {
        try (Transaction t = TransferUtil.getTransaction();){
            class_1799 remainder;
            class_1799 stack = armInteractionPoint.extract((TransactionContext)t);
            class_1799 class_17992 = remainder = stack.method_7960() ? stack : this.simulateInsertion(stack);
            if (stack.method_7962(remainder)) {
                int n = stack.method_7947() - remainder.method_7947();
                return n;
            }
            int n = stack.method_7947();
            return n;
        }
    }

    private class_1799 simulateInsertion(class_1799 stack) {
        try (Transaction t = TransferUtil.getTransaction();){
            for (ArmInteractionPoint armInteractionPoint : this.outputs) {
                if (armInteractionPoint.isValid()) {
                    stack = armInteractionPoint.insert(stack, (TransactionContext)t);
                }
                if (!stack.method_7960()) continue;
                break;
            }
            class_1799 class_17992 = stack;
            return class_17992;
        }
    }

    protected void depositItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            class_1799 toInsert = this.heldItem.method_7972();
            try (Transaction t = TransferUtil.getTransaction();){
                class_1799 remainder = armInteractionPoint.insert(toInsert, (TransactionContext)t);
                t.commit();
                this.heldItem = remainder;
                if (armInteractionPoint instanceof AllArmInteractionPointTypes.JukeboxPoint && remainder.method_7960()) {
                    this.award(AllAdvancements.MUSICAL_ARM);
                }
            }
        }
        this.phase = this.heldItem.method_7960() ? Phase.SEARCH_INPUTS : Phase.SEARCH_OUTPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.method_5431();
        if (!this.field_11863.field_9236) {
            this.award(AllAdvancements.MECHANICAL_ARM);
        }
    }

    protected void collectItem() {
        ArmInteractionPoint armInteractionPoint = this.getTargetedInteractionPoint();
        if (armInteractionPoint != null && armInteractionPoint.isValid()) {
            try (Transaction t = TransferUtil.getTransaction();){
                int amountExtracted = this.getDistributableAmount(armInteractionPoint);
                if (amountExtracted == 0) {
                    return;
                }
                class_1799 prevHeld = this.heldItem;
                this.heldItem = armInteractionPoint.extract(amountExtracted, (TransactionContext)t);
                this.phase = Phase.SEARCH_OUTPUTS;
                this.chasedPointProgress = 0.0f;
                this.chasedPointIndex = -1;
                this.sendData();
                this.method_5431();
                if (!prevHeld.method_7962(this.heldItem)) {
                    this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15245, 0.125f, 0.5f + Create.RANDOM.nextFloat() * 0.25f);
                }
                t.commit();
                return;
            }
        }
        this.phase = Phase.SEARCH_INPUTS;
        this.chasedPointProgress = 0.0f;
        this.chasedPointIndex = -1;
        this.sendData();
        this.method_5431();
    }

    public void redstoneUpdate() {
        if (this.field_11863.field_9236) {
            return;
        }
        boolean blockPowered = this.field_11863.method_8479(this.field_11867);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
        if (!this.redstoneLocked) {
            this.searchForItem();
        }
    }

    @Override
    public void transform(StructureTransform transform) {
        if (this.interactionPointTag == null) {
            return;
        }
        for (class_2520 tag : this.interactionPointTag) {
            ArmInteractionPoint.transformPos((class_2487)tag, transform);
        }
        this.notifyUpdate();
    }

    protected boolean isAreaActuallyLoaded(class_2338 center, int range) {
        if (!this.field_11863.method_22343(center.method_10069(-range, -range, -range), center.method_10069(range, range, range))) {
            return false;
        }
        if (this.field_11863.field_9236) {
            int minY = center.method_10264() - range;
            int maxY = center.method_10264() + range;
            if (maxY < this.field_11863.method_31607() || minY >= this.field_11863.method_31600()) {
                return false;
            }
            int minX = center.method_10263() - range;
            int minZ = center.method_10260() - range;
            int maxX = center.method_10263() + range;
            int maxZ = center.method_10260() + range;
            int minChunkX = class_4076.method_18675((int)minX);
            int maxChunkX = class_4076.method_18675((int)maxX);
            int minChunkZ = class_4076.method_18675((int)minZ);
            int maxChunkZ = class_4076.method_18675((int)maxZ);
            class_2802 chunkSource = this.field_11863.method_8398();
            for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
                for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                    if (chunkSource.method_12123(chunkX, chunkZ)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void initInteractionPoints() {
        if (!this.updateInteractionPoints || this.interactionPointTag == null) {
            return;
        }
        if (!this.isAreaActuallyLoaded(this.field_11867, ArmBlockEntity.getRange() + 1)) {
            return;
        }
        this.inputs.clear();
        this.outputs.clear();
        boolean hasBlazeBurner = false;
        for (class_2520 tag : this.interactionPointTag) {
            ArmInteractionPoint point = ArmInteractionPoint.deserialize((class_2487)tag, this.field_11863, this.field_11867);
            if (point == null) continue;
            if (point.getMode() == ArmInteractionPoint.Mode.DEPOSIT) {
                this.outputs.add(point);
            } else if (point.getMode() == ArmInteractionPoint.Mode.TAKE) {
                this.inputs.add(point);
            }
            hasBlazeBurner |= point instanceof AllArmInteractionPointTypes.BlazeBurnerPoint;
        }
        if (!this.field_11863.field_9236) {
            if (this.outputs.size() >= 10) {
                this.award(AllAdvancements.ARM_MANY_TARGETS);
            }
            if (hasBlazeBurner) {
                this.award(AllAdvancements.ARM_BLAZE_BURNER);
            }
        }
        this.updateInteractionPoints = false;
        this.sendData();
        this.method_5431();
    }

    public void writeInteractionPoints(class_2487 compound) {
        if (this.updateInteractionPoints && this.interactionPointTag != null) {
            compound.method_10566("InteractionPoints", (class_2520)this.interactionPointTag);
        } else {
            class_2499 pointsNBT = new class_2499();
            this.inputs.stream().map(aip -> aip.serialize(this.field_11867)).forEach(arg_0 -> pointsNBT.add(arg_0));
            this.outputs.stream().map(aip -> aip.serialize(this.field_11867)).forEach(arg_0 -> pointsNBT.add(arg_0));
            compound.method_10566("InteractionPoints", (class_2520)pointsNBT);
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.writeInteractionPoints(compound);
        NBTHelper.writeEnum(compound, "Phase", this.phase);
        compound.method_10556("Powered", this.redstoneLocked);
        compound.method_10556("Goggles", this.goggles);
        compound.method_10566("HeldItem", NBTSerializer.serializeNBT((Object)this.heldItem));
        compound.method_10569("TargetPointIndex", this.chasedPointIndex);
        compound.method_10548("MovementProgress", this.chasedPointProgress);
    }

    @Override
    public void writeSafe(class_2487 compound) {
        super.writeSafe(compound);
        this.writeInteractionPoints(compound);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        int previousIndex = this.chasedPointIndex;
        Phase previousPhase = this.phase;
        class_2499 interactionPointTagBefore = this.interactionPointTag;
        super.read(compound, clientPacket);
        this.heldItem = class_1799.method_7915((class_2487)compound.method_10562("HeldItem"));
        this.phase = NBTHelper.readEnum(compound, "Phase", Phase.class);
        this.chasedPointIndex = compound.method_10550("TargetPointIndex");
        this.chasedPointProgress = compound.method_10583("MovementProgress");
        this.interactionPointTag = compound.method_10554("InteractionPoints", 10);
        this.redstoneLocked = compound.method_10577("Powered");
        boolean hadGoggles = this.goggles;
        this.goggles = compound.method_10577("Goggles");
        if (!clientPacket) {
            return;
        }
        if (hadGoggles != this.goggles) {
            EnvExecutor.runWhenOn((EnvType)EnvType.CLIENT, () -> () -> InstancedRenderDispatcher.enqueueUpdate((class_2586)this));
        }
        boolean ceiling = this.isOnCeiling();
        if (interactionPointTagBefore == null || interactionPointTagBefore.size() != this.interactionPointTag.size()) {
            this.updateInteractionPoints = true;
        }
        if (previousIndex != this.chasedPointIndex || previousPhase != this.phase) {
            ArmInteractionPoint targetedPoint;
            ArmInteractionPoint previousPoint = null;
            if (previousPhase == Phase.MOVE_TO_INPUT && previousIndex < this.inputs.size()) {
                previousPoint = this.inputs.get(previousIndex);
            }
            if (previousPhase == Phase.MOVE_TO_OUTPUT && previousIndex < this.outputs.size()) {
                previousPoint = this.outputs.get(previousIndex);
            }
            ArmAngleTarget armAngleTarget = this.previousTarget = previousPoint == null ? ArmAngleTarget.NO_TARGET : previousPoint.getTargetAngles(this.field_11867, ceiling);
            if (previousPoint != null) {
                this.previousBaseAngle = this.previousTarget.baseAngle;
            }
            if ((targetedPoint = this.getTargetedInteractionPoint()) != null) {
                targetedPoint.updateCachedState();
            }
        }
    }

    public static int getRange() {
        return (Integer)AllConfigs.server().logistics.mechanicalArmRange.get();
    }

    @Override
    public boolean addToTooltip(List<class_2561> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (isPlayerSneaking) {
            return false;
        }
        if (this.tooltipWarmup > 0) {
            return false;
        }
        if (!this.inputs.isEmpty()) {
            return false;
        }
        if (!this.outputs.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.mechanical_arm_no_targets", new Object[0]);
        return true;
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        for (ArmInteractionPoint input : this.inputs) {
            input.setLevel(level);
        }
        for (ArmInteractionPoint output : this.outputs) {
            output.setLevel(level);
        }
    }

    public static enum Phase {
        SEARCH_INPUTS,
        MOVE_TO_INPUT,
        SEARCH_OUTPUTS,
        MOVE_TO_OUTPUT,
        DANCING;

    }

    public static enum SelectionMode implements INamedIconOptions
    {
        ROUND_ROBIN(AllIcons.I_ARM_ROUND_ROBIN),
        FORCED_ROUND_ROBIN(AllIcons.I_ARM_FORCED_ROUND_ROBIN),
        PREFER_FIRST(AllIcons.I_ARM_PREFER_FIRST);

        private final String translationKey;
        private final AllIcons icon;

        private SelectionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "mechanical_arm.selection_mode." + Lang.asId(this.name());
        }

        @Override
        public AllIcons getIcon() {
            return this.icon;
        }

        @Override
        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    private class SelectionModeValueBox
    extends CenteredSideValueBoxTransform {
        public SelectionModeValueBox() {
            super((class_2680 blockState, class_2350 direction) -> !direction.method_10166().method_10178());
        }

        @Override
        public class_243 getLocalOffset(class_2680 state) {
            int yPos = (Boolean)state.method_11654((class_2769)ArmBlock.CEILING) != false ? 13 : 3;
            class_243 location = VecHelper.voxelSpace(8.0, yPos, 15.5);
            location = VecHelper.rotateCentered(location, AngleHelper.horizontalAngle(this.getSide()), class_2350.class_2351.field_11052);
            return location;
        }

        @Override
        public float getScale() {
            return super.getScale();
        }
    }
}

