/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.entity;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.AssemblyException;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.ContraptionType;
import com.simibubi.create.content.contraptions.MountedStorageManager;
import com.simibubi.create.content.contraptions.actors.trainControls.ControlsBlock;
import com.simibubi.create.content.contraptions.minecart.TrainCargoManager;
import com.simibubi.create.content.contraptions.render.ContraptionLighter;
import com.simibubi.create.content.contraptions.render.NonStationaryLighter;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.entity.ArrivalSoundQueue;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.CarriageContraptionEntity;
import com.simibubi.create.foundation.fluid.CombinedTankWrapper;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.util.FluidStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3499;
import org.apache.commons.lang3.tuple.Pair;

public class CarriageContraption
extends Contraption {
    private class_2350 assemblyDirection;
    private boolean forwardControls;
    private boolean backwardControls;
    public Couple<Boolean> blazeBurnerConductors;
    public Map<class_2338, Couple<Boolean>> conductorSeats;
    public ArrivalSoundQueue soundQueue;
    protected MountedStorageManager storageProxy;
    private int bogeys;
    private boolean sidewaysControls;
    private class_2338 secondBogeyPos;
    private List<class_2338> assembledBlazeBurners;
    public int portalCutoffMin;
    public int portalCutoffMax;
    static final Contraption.ContraptionInvWrapper fallbackItems = new Contraption.ContraptionInvWrapper(new Storage[0]);
    static final CombinedTankWrapper fallbackFluids = new CombinedTankWrapper(new Storage[0]);
    private Collection<class_2586> specialRenderedBEsOutsidePortal = new ArrayList<class_2586>();

    public CarriageContraption() {
        this.conductorSeats = new HashMap<class_2338, Couple<Boolean>>();
        this.assembledBlazeBurners = new ArrayList<class_2338>();
        this.blazeBurnerConductors = Couple.create(false, false);
        this.soundQueue = new ArrivalSoundQueue();
        this.portalCutoffMin = Integer.MIN_VALUE;
        this.portalCutoffMax = Integer.MAX_VALUE;
        this.storage = new TrainCargoManager();
    }

    public void setSoundQueueOffset(int offset) {
        this.soundQueue.offset = offset;
    }

    public CarriageContraption(class_2350 assemblyDirection) {
        this();
        this.assemblyDirection = assemblyDirection;
        this.bogeys = 0;
    }

    @Override
    public boolean assemble(class_1937 world, class_2338 pos) throws AssemblyException {
        if (!this.searchMovedStructure(world, pos, null)) {
            return false;
        }
        if (this.blocks.size() <= 1) {
            return false;
        }
        if (this.bogeys == 0) {
            return false;
        }
        if (this.bogeys > 2) {
            throw new AssemblyException((class_2561)Lang.translateDirect("train_assembly.too_many_bogeys", this.bogeys));
        }
        if (this.sidewaysControls) {
            throw new AssemblyException((class_2561)Lang.translateDirect("train_assembly.sideways_controls", new Object[0]));
        }
        for (class_2338 blazePos : this.assembledBlazeBurners) {
            for (class_2350 direction : Iterate.directionsInAxis(this.assemblyDirection.method_10166())) {
                if (!this.inControl(blazePos, direction)) continue;
                this.blazeBurnerConductors.set(direction != this.assemblyDirection, true);
            }
        }
        for (class_2338 seatPos : this.getSeats()) {
            for (class_2350 direction : Iterate.directionsInAxis(this.assemblyDirection.method_10166())) {
                if (!this.inControl(seatPos, direction)) continue;
                this.conductorSeats.computeIfAbsent(seatPos, p -> Couple.create(false, false)).set(direction != this.assemblyDirection, true);
            }
        }
        return true;
    }

    public boolean inControl(class_2338 pos, class_2350 direction) {
        class_2338 controlsPos = pos.method_10093(direction);
        if (!this.blocks.containsKey(controlsPos)) {
            return false;
        }
        class_3499.class_3501 info = (class_3499.class_3501)this.blocks.get(controlsPos);
        if (!AllBlocks.TRAIN_CONTROLS.has(info.field_15596)) {
            return false;
        }
        return info.field_15596.method_11654((class_2769)ControlsBlock.field_11177) == direction.method_10153();
    }

    public void swapStorageAfterAssembly(CarriageContraptionEntity cce) {
        Carriage carriage = cce.getCarriage();
        if (carriage.storage == null) {
            carriage.storage = (TrainCargoManager)this.storage;
            this.storage = new MountedStorageManager();
        }
        this.storageProxy = carriage.storage;
    }

    public void returnStorageForDisassembly(MountedStorageManager storage) {
        this.storage = storage;
    }

    @Override
    protected boolean isAnchoringBlockAt(class_2338 pos) {
        return false;
    }

    @Override
    protected Pair<class_3499.class_3501, class_2586> capture(class_1937 world, class_2338 pos) {
        class_2248 posCoord2;
        class_2680 blockState = world.method_8320(pos);
        if (ArrivalSoundQueue.isPlayable(blockState)) {
            int anchorCoord = VecHelper.getCoordinate((class_2382)this.anchor, this.assemblyDirection.method_10166());
            int posCoord2 = VecHelper.getCoordinate((class_2382)pos, this.assemblyDirection.method_10166());
            this.soundQueue.add((posCoord2 - anchorCoord) * this.assemblyDirection.method_10171().method_10181(), this.toLocalPos(pos));
        }
        if ((posCoord2 = blockState.method_26204()) instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)posCoord2;
            boolean captureBE = bogey.captureBlockEntityForTrain();
            ++this.bogeys;
            if (this.bogeys == 2) {
                this.secondBogeyPos = pos;
            }
            return Pair.of((Object)new class_3499.class_3501(pos, blockState, captureBE ? this.getBlockEntityNBT(world, pos) : null), captureBE ? world.method_8321(pos) : null);
        }
        if (AllBlocks.BLAZE_BURNER.has(blockState) && blockState.method_11654(BlazeBurnerBlock.HEAT_LEVEL) != BlazeBurnerBlock.HeatLevel.NONE) {
            this.assembledBlazeBurners.add(this.toLocalPos(pos));
        }
        if (AllBlocks.TRAIN_CONTROLS.has(blockState)) {
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)ControlsBlock.field_11177);
            if (facing.method_10166() != this.assemblyDirection.method_10166()) {
                this.sidewaysControls = true;
            } else {
                boolean forwards;
                boolean bl = forwards = facing == this.assemblyDirection;
                if (forwards) {
                    this.forwardControls = true;
                } else {
                    this.backwardControls = true;
                }
            }
        }
        return super.capture(world, pos);
    }

    @Override
    public class_2487 writeNBT(boolean spawnPacket) {
        class_2487 tag = super.writeNBT(spawnPacket);
        NBTHelper.writeEnum(tag, "AssemblyDirection", this.getAssemblyDirection());
        tag.method_10556("FrontControls", this.forwardControls);
        tag.method_10556("BackControls", this.backwardControls);
        tag.method_10556("FrontBlazeConductor", ((Boolean)this.blazeBurnerConductors.getFirst()).booleanValue());
        tag.method_10556("BackBlazeConductor", ((Boolean)this.blazeBurnerConductors.getSecond()).booleanValue());
        class_2499 list = NBTHelper.writeCompoundList(this.conductorSeats.entrySet(), e -> {
            class_2487 compoundTag = new class_2487();
            compoundTag.method_10566("Pos", (class_2520)class_2512.method_10692((class_2338)((class_2338)e.getKey())));
            compoundTag.method_10556("Forward", ((Boolean)((Couple)e.getValue()).getFirst()).booleanValue());
            compoundTag.method_10556("Backward", ((Boolean)((Couple)e.getValue()).getSecond()).booleanValue());
            return compoundTag;
        });
        tag.method_10566("ConductorSeats", (class_2520)list);
        this.soundQueue.serialize(tag);
        return tag;
    }

    @Override
    public void readNBT(class_1937 world, class_2487 nbt, boolean spawnData) {
        this.assemblyDirection = NBTHelper.readEnum(nbt, "AssemblyDirection", class_2350.class);
        this.forwardControls = nbt.method_10577("FrontControls");
        this.backwardControls = nbt.method_10577("BackControls");
        this.blazeBurnerConductors = Couple.create(nbt.method_10577("FrontBlazeConductor"), nbt.method_10577("BackBlazeConductor"));
        this.conductorSeats.clear();
        NBTHelper.iterateCompoundList(nbt.method_10554("ConductorSeats", 10), c -> this.conductorSeats.put(class_2512.method_10691((class_2487)c.method_10562("Pos")), Couple.create(c.method_10577("Forward"), c.method_10577("Backward"))));
        this.soundQueue.deserialize(nbt);
        super.readNBT(world, nbt, spawnData);
    }

    @Override
    public boolean canBeStabilized(class_2350 facing, class_2338 localPos) {
        return false;
    }

    @Override
    protected MountedStorageManager getStorageForSpawnPacket() {
        return this.storageProxy;
    }

    @Override
    public ContraptionType getType() {
        return ContraptionType.CARRIAGE;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public ContraptionLighter<?> makeLighter() {
        return new NonStationaryLighter<CarriageContraption>(this);
    }

    public class_2350 getAssemblyDirection() {
        return this.assemblyDirection;
    }

    public boolean hasForwardControls() {
        return this.forwardControls;
    }

    public boolean hasBackwardControls() {
        return this.backwardControls;
    }

    public class_2338 getSecondBogeyPos() {
        return this.secondBogeyPos;
    }

    @Override
    public Collection<class_3499.class_3501> getRenderedBlocks() {
        if (this.notInPortal()) {
            return super.getRenderedBlocks();
        }
        this.specialRenderedBEsOutsidePortal = new ArrayList<class_2586>();
        this.specialRenderedBlockEntities.stream().filter(be -> !this.isHiddenInPortal(be.method_11016())).forEach(this.specialRenderedBEsOutsidePortal::add);
        ArrayList<class_3499.class_3501> values = new ArrayList<class_3499.class_3501>();
        for (Map.Entry entry : this.blocks.entrySet()) {
            class_2338 pos = (class_2338)entry.getKey();
            if (this.withinVisible(pos)) {
                values.add((class_3499.class_3501)entry.getValue());
                continue;
            }
            if (!this.atSeam(pos)) continue;
            values.add(new class_3499.class_3501(pos, class_2246.field_10399.method_9564(), null));
        }
        return values;
    }

    @Override
    public Collection<class_2586> getSpecialRenderedTEs() {
        if (this.notInPortal()) {
            return super.getSpecialRenderedTEs();
        }
        return this.specialRenderedBEsOutsidePortal;
    }

    @Override
    public Optional<List<class_238>> getSimplifiedEntityColliders() {
        if (this.notInPortal()) {
            return super.getSimplifiedEntityColliders();
        }
        return Optional.empty();
    }

    @Override
    public boolean isHiddenInPortal(class_2338 localPos) {
        if (this.notInPortal()) {
            return super.isHiddenInPortal(localPos);
        }
        return !this.withinVisible(localPos) || this.atSeam(localPos);
    }

    public boolean notInPortal() {
        return this.portalCutoffMin == Integer.MIN_VALUE && this.portalCutoffMax == Integer.MAX_VALUE;
    }

    public boolean atSeam(class_2338 localPos) {
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return coord == this.portalCutoffMin || coord == this.portalCutoffMax;
    }

    public boolean withinVisible(class_2338 localPos) {
        class_2350 facing = this.assemblyDirection;
        class_2350.class_2351 axis = facing.method_10170().method_10166();
        int coord = axis.method_10173(localPos.method_10260(), localPos.method_10264(), localPos.method_10263()) * -facing.method_10171().method_10181();
        return coord > this.portalCutoffMin && coord < this.portalCutoffMax;
    }

    @Override
    public Contraption.ContraptionInvWrapper getSharedInventory() {
        return this.storageProxy == null ? fallbackItems : this.storageProxy.getItems();
    }

    @Override
    public CombinedTankWrapper getSharedFluidTanks() {
        return this.storageProxy == null ? fallbackFluids : this.storageProxy.getFluids();
    }

    @Override
    public void handleContraptionFluidPacket(class_2338 localPos, FluidStack containedFluid) {
        this.storage.updateContainedFluid(localPos, containedFluid);
    }

    @Override
    public void tickStorage(AbstractContraptionEntity entity) {
        if (entity.field_6002.field_9236) {
            this.storage.entityTick(entity);
        } else if (this.storageProxy != null) {
            this.storageProxy.entityTick(entity);
        }
    }
}

